// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-service-ensemble.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSMap
import com.yandex.xplat.common.set
import com.yandex.xplat.common.undefinedToNull

public enum class TusEnv(val value: String) {
    PROD("prod"),
    TEST("test"),
    EXTERNAL("external"),
    ;
    override fun toString(): String = value
}
public open class UserServiceEnsemble(private val userService: UserService, requiredAccounts: YSArray<AccountType2>, private val tusConsumer: String, userTags: YSArray<String>) {
    private var userEnsembleMap: YSMap<AccountType2, UserPool>
    init {
        this.userEnsembleMap = mutableMapOf<AccountType2, UserPool>()
        for (i in (0 until requiredAccounts.size step 1)) {
            val accountType = requiredAccounts[i]
            this.userEnsembleMap.set(accountType, this.getUserPool(accountType, userTags))
        }
    }
    open fun getAccountByType(type: AccountType2): UserPool {
        return requireNonNull(undefinedToNull(this.userEnsembleMap.get(type)), "Пул юзеров не может быть null!")
    }

    private fun getUserPool(accountType: AccountType2, userTags: YSArray<String>): UserPool {
        val accountToDebug = this.getDebugAccount(accountType)
        if (accountToDebug != null) {
            return DebugUserPool(accountToDebug!!)
        }
        val userTag = if (userTags.size > 0) userTags.joinToString(",") else UserServiceEnsemble.getTagByAccountType(accountType)
        val tusEnv = UserServiceEnsemble.getEnvironmentByAccountType(accountType)
        return UserServicePool(this.userService, tusEnv, this.tusConsumer, userTag)
    }

    private fun getDebugAccount(accountType: AccountType2): UserAccount? {
        when (accountType) {
            else -> {
                return null
            }
        }
    }

    companion object {
        @JvmStatic
        private fun getTagByAccountType(type: AccountType2): String {
            when (type) {
                AccountType2.Yandex -> {
                    return "yandex"
                }
                AccountType2.YandexTeam -> {
                    return "yandex-team"
                }
                AccountType2.Yahoo -> {
                    return "yahoo"
                }
                AccountType2.Google -> {
                    return "google"
                }
                AccountType2.Mail -> {
                    return "mail.ru"
                }
                AccountType2.Rambler -> {
                    return "rambler"
                }
                AccountType2.Hotmail -> {
                    return "hotmail"
                }
                AccountType2.Outlook -> {
                    return "outlook"
                }
                AccountType2.YandexTest -> {
                    return "yandextest"
                }
                AccountType2.Other -> {
                }
                else -> {
                    return "other"
                }
            }
            return "other"
        }

        @JvmStatic
        private fun getEnvironmentByAccountType(type: AccountType2): TusEnv {
            when (type) {
                AccountType2.YandexTest -> {
                    return TusEnv.TEST
                }
                AccountType2.Outlook -> {
                    return TusEnv.EXTERNAL
                }
                AccountType2.Other -> {
                    return TusEnv.EXTERNAL
                }
                else -> {
                    return TusEnv.PROD
                }
            }
        }

    }
}

