// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-service-pool.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.int64
import com.yandex.xplat.common.int64ToInt32

public open class UserServicePool(private var userService: UserService, private var tusEnv: TusEnv, private var tusConsumer: String, private var tag: String?): UserPool {
    open override fun tryAcquire(tryAcquireTimeoutMs: Long, lockTtlMs: Long): UserLock? {
        val start = currentTimeMs()
        while (currentTimeMs() < start + tryAcquireTimeoutMs) {
            val user = this.userService.getAccount(this.tusEnv, this.tusConsumer, this.tag, int64ToInt32(lockTtlMs / int64(1000)), false, null)
            if (user != null) {
                return UserServiceLock(this.userService, this.tusEnv, this.tusConsumer, user!!)
            }
        }
        return null
    }

    open override fun reset(): Unit {
        val account = this.userService.getAccount(this.tusEnv, this.tusConsumer, this.tag, 0, true, null)
        if (account == null) {
            return
        }
        this.userService.unlockAccount(this.tusEnv, account!!.uid)
    }

}

public open class UserServiceLock(private var userService: UserService, private var tusEnv: TusEnv, private var tusConsumer: String, private var account: UserServiceAccount): UserLock {
    open override fun lockedAccount(): UserAccount {
        return UserAccount(this.account.login, this.account.password, this.account.uid)
    }

    open override fun ping(newLockTtlMs: Long): Unit {
        this.userService.getAccount(this.tusEnv, this.tusConsumer, null, int64ToInt32(newLockTtlMs / int64(1000)), true, this.account.uid)
    }

    open override fun release(): Unit {
        this.userService.unlockAccount(this.tusEnv, this.account.uid)
    }

}

