// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/testpalm-network-request.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public open class TestpalmTrustedNetworkRequest(private val platform: MBTPlatform): BaseNetworkRequest() {
    open override fun encoding(): RequestEncoding {
        return JsonRequestEncoding()
    }

    open override fun method(): NetworkMethod {
        return NetworkMethod.`get`
    }

    open override fun targetPath(): String {
        return "testcases/${TestpalmTrustedNetworkRequest.getPathByPlatform(this.platform)}"
    }

    open override fun urlExtra(): NetworkParams {
        return MapJSONItem().putString("expression", TestpalmTrustedNetworkRequest.getFilterByPlatform(this.platform)).putString("include", "id")
    }

    companion object {
        @JvmStatic
        private fun getFilterByPlatform(platform: MBTPlatform): String {
            when (platform) {
                MBTPlatform.IOS -> {
                    return "{\"type\":\"AND\",\"left\":{\"type\":\"EQ\",\"key\":\"attributes.5c8abacebb580fb2967a0e23\",\"value\":\"Trusted\"},\"right\":{\"type\":\"EQ\",\"key\":\"attributes.5c4acdf4d477414d135c4d29\",\"value\":\"iOS\"}}"
                }
                MBTPlatform.Android -> {
                    return "{\"type\":\"AND\",\"left\":{\"type\":\"EQ\",\"key\":\"attributes.5c8abacebb580fb2967a0e23\",\"value\":\"Trusted\"},\"right\":{\"type\":\"EQ\",\"key\":\"attributes.5c4acdf4d477414d135c4d29\",\"value\":\"Android\"}}"
                }
                else -> {
                    return ""
                }
            }
        }

        @JvmStatic
        private fun getPathByPlatform(platform: MBTPlatform): String {
            when (platform) {
                MBTPlatform.IOS -> {
                    return "mobilemail"
                }
                MBTPlatform.Android -> {
                    return "mobilemail"
                }
                else -> {
                    return ""
                }
            }
        }

    }
}

