// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/utils.ts >>>

package com.yandex.xplat.testopithecus.common

import com.yandex.xplat.common.*

public fun <T> filterByOrders(array: YSArray<T>, byOrders: YSSet<Int>): YSArray<T> {
    val result: YSArray<T> = mutableListOf()
    for (i in byOrders.values()) {
        result.add(array[i])
    }
    return result
}

public fun <K, V> valuesArray(iterable: YSMap<K, V>): YSArray<V> {
    val result: YSArray<V> = mutableListOf()
    for (element in iterable.values()) {
        result.add(element)
    }
    return result
}

public fun currentTimeMs(): Long {
    return int64(YSDate.now())
}

public fun <T> copyArray(array: YSArray<T>): YSArray<T> {
    val result: YSArray<T> = mutableListOf()
    for (element in array) {
        result.add(element)
    }
    return result
}

public fun <T> copySet(`set`: YSSet<T>): YSSet<T> {
    val result: YSSet<T> = YSSet<T>()
    for (element in `set`.values()) {
        result.add(element)
    }
    return result
}

public fun <T, S> copyMap(map: YSMap<T, S>): YSMap<T, S> {
    val result: YSMap<T, S> = mutableMapOf<T, S>()
    map.__forEach(__LBL__Utils_1@ {
        value, key ->
        result.set(key, value)
    })
    return result
}

public fun <T> requireNonNull(obj: T?, message: String): T {
    if (obj == null) {
        fail(message)
    }
    return obj!!
}

public fun getSliceIndexesForBuckets(total: Int, bucketsTotal: Int): YSArray<Int> {
    val buckets: YSArray<Int> = mutableListOf()
    val bucketsSliceStartIndexes: YSArray<Int> = mutableListOf()
    val remainder: Int = total % bucketsTotal
    val intPart: Int = (total - remainder) / bucketsTotal
    var currentBucketStartIndex: Int = 0
    for (`_` in (0 until bucketsTotal step 1)) {
        buckets.add(intPart)
    }
    for (i in (0 until remainder step 1)) {
        buckets[i] += 1
    }
    for (i in (0 until bucketsTotal step 1)) {
        bucketsSliceStartIndexes.add(currentBucketStartIndex)
        currentBucketStartIndex += buckets[i]
    }
    bucketsSliceStartIndexes.add(currentBucketStartIndex)
    Log.info("All buckets distribution ${buckets}")
    Log.info("All buckets slice start indexes ${bucketsSliceStartIndexes}")
    return bucketsSliceStartIndexes
}

public open class TestopithecusConstants {
    companion object {
        @JvmStatic val SWIFT_CONSTRUCTOR_VARIABLE_WORKAROUND_TITLE: String = "Ignore this param. This is a workaround for constructor override bug in our Swift Generator. See: https://st.yandex-team.ru/SSP-156"
    }
}

public fun getTrustedCases(platform: MBTPlatform, testPalmToken: String, network: SyncNetwork, jsonSerializer: JSONSerializer): YSArray<Int> {
    val ids: YSArray<Int> = mutableListOf()
    if (testPalmToken == "") {
        Log.info("No token for testpalm! Can't get trusted tests!")
        return mutableListOf()
    }
    val response: String = network.syncExecute("https://testpalm-api.yandex-team.ru", TestpalmTrustedNetworkRequest(platform), testPalmToken).getValue()
    val json: ArrayJSONItem = jsonSerializer.deserialize(response).getValue() as ArrayJSONItem
    json.asArray().forEach(__LBL__Utils_2@ {
        tpCase ->
        val id = (tpCase as MapJSONItem).getInt32("id")
        if (id != null) {
            ids.add(id)
        }
    })
    return ids
}

