// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM event-logs/action-parser.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.MapJSONItem
import com.yandex.xplat.eventus.EventNames
import com.yandex.xplat.testopithecus.common.MBTAction

public open class ActionParser {
    open fun parseActionFromJson(json: MapJSONItem): MBTAction {
        when (json.getString("event_name")) {
            EventNames.LIST_MESSAGE_OPEN -> {
                return OpenMessageAction(json.getInt32("order")!!)
            }
            EventNames.LIST_MESSAGE_DELETE -> {
                return DeleteMessageByLongSwipeAction(json.getInt32("order")!!)
            }
            EventNames.LIST_MESSAGE_REFRESH -> {
                return RefreshMessageListAction()
            }
            EventNames.MESSAGE_VIEW_BACK -> {
                return BackToMaillistFromMessageViewAction()
            }
            EventNames.MESSAGE_VIEW_DELETE -> {
                return DeleteCurrentMessage()
            }
            else -> {
                throw Error("Unknown action ${json.getString("event_name")}")
            }
        }
    }

    open fun parseActionFromString(extrasString: String): MBTAction {
        return this.parseActionFromJson(this.parse(extrasString))
    }

    open fun parse(_extrasString: String): MapJSONItem {
        return MapJSONItem()
    }

}

