// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM event-logs/scenario-parser.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.testopithecus.common.TestPlan

public open class ScenarioParser(private var actionParser: ActionParser, private var jsonSerializer: JSONSerializer) {
    open fun parse(eventStrings: YSArray<String>): TestPlan {
        val testPlan = TestPlan.empty()
        for (event in eventStrings) {
            testPlan.then(this.actionParser.parseActionFromString(event))
        }
        return testPlan
    }

    open fun parseFromJsonText(text: String): TestPlan {
        val actions = this.jsonSerializer.deserialize(text).getValue() as ArrayJSONItem
        val testPlan = TestPlan.empty()
        for (json in actions.asArray()) {
            testPlan.then(this.actionParser.parseActionFromJson(json as MapJSONItem))
        }
        return testPlan
    }

    open fun parseFromText(text: String): TestPlan {
        val lines: YSArray<String> = mutableListOf()
        for (line in text.split("\n")) {
            lines.add(line.substring(line.search("{") as Int, (line.search("}") as Int) + 1))
        }
        return this.parse(lines.filter( {
            line ->
            line.length > 0
        }))
    }

}

