// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/mailbox-downloader.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.mapi.*
import com.yandex.xplat.testopithecus.common.*

public open class MailboxDownloader(private var clients: YSArray<MailboxClient>, private var logger: Logger): AppModelProvider {
    open override fun takeAppModel(): AppModel {
        this.logger.info("Downloading mailbox started")
        val accountsData: YSArray<AccountMailboxData> = mutableListOf()
        for (client in this.clients) {
            this.logger.info("Downloading account (${client.oauthAccount.account.login}) started")
            val isTabEnabled = client.getSettings().payload!!.userParameters.showFoldersTabs
            val folderList = client.getFolderList(isTabEnabled).filter( {
                folder ->
                folder.name != DefaultFolderName.outgoing
            })
            val allLabels = client.getLabelList()
            val labelList = allLabels.filter( {
                label ->
                label.type == LabelType.user
            })
            val fidToFolder = mutableMapOf<FolderId, Folder>()
            val lidToLabel = mutableMapOf<LabelID, Label>()
            folderList.forEach( {
                folder ->
                fidToFolder.set(folder.fid, folder)
            })
            allLabels.forEach( {
                label ->
                lidToLabel.set(label.lid, label)
            })
            val messages = mutableMapOf<MessageId, FullMessage>()
            val messageToFolder = mutableMapOf<MessageId, FolderName>()
            val messageToLabels = mutableMapOf<MessageId, YSArray<LabelName>>()
            val threads = mutableMapOf<ID, YSSet<MessageId>>()
            val aliases = client.getSettings().payload!!.accountInformation.emails.map( {
                email ->
                display(email)
            })
            val contacts = client.getAllContactsList(1000).map( {
                contact ->
                contact.email
            })
            val zeroSuggest = client.getZeroSuggest().map( {
                suggest ->
                suggest.show_text
            })
            val accountSettings = AccountSettingsModel(client.getSettings().payload!!.settingsSetup.folderThreadView, client.getSettings().payload!!.userParameters.showFoldersTabs, client.getSettings().payload!!.settingsSetup.mobileSign, client.getSettings().payload!!.settingsSetup.signatureTop, folderList.map( {
                folder ->
                folder.name!!
            }))
            for (folder in folderList) {
                val messagesDTO = if (isFolderOfThreadedType(folder.type)) client.getThreadsInFolder(folder.fid, 10, isTabEnabled) else client.getMessagesInFolder(folder.fid, 10, isTabEnabled)
                messagesDTO.forEach(__LBL__MailboxDownloader_1@ {
                    messageDTO ->
                    val messageModel = FullMessage.fromMeta(messageDTO)
                    val tid = messageDTO.tid
                    val threadSize = messageModel.head.threadCounter
                    if (tid != null && threadSize != null) {
                        for (threadMessageDTO in client.getMessagesInThread(tid, threadSize, isTabEnabled)) {
                            val mid = threadMessageDTO.mid
                            if (!threads.has(tid)) {
                                threads.set(tid, YSSet())
                            }
                            threads.`get`(tid)!!.add(mid)
                            messages.set(mid, FullMessage.fromMeta(threadMessageDTO))
                            messageToFolder.set(mid, requireNonNull(undefinedToNull(fidToFolder.`get`(threadMessageDTO.fid)), "Folder with fid ${threadMessageDTO.fid} has no folder!").name!!)
                            messageToLabels.set(mid, this.getLabelNames(threadMessageDTO, lidToLabel))
                        }
                    } else {
                        val mid = messageDTO.mid
                        messages.set(mid, messageModel)
                        messageToFolder.set(mid, requireNonNull(undefinedToNull(fidToFolder.`get`(messageDTO.fid)), "Folder with fid ${messageDTO.fid} has no folder!").name!!)
                        messageToLabels.set(mid, this.getLabelNames(messageDTO, lidToLabel))
                    }
                })
            }
            val folderToMessages: YSMap<FolderName, YSSet<MessageId>> = mutableMapOf<FolderName, YSSet<MessageId>>()
            val tabsToMessages: YSMap<FolderName, YSSet<MessageId>> = mutableMapOf<FolderName, YSSet<MessageId>>()
            for (folderDTO in folderList) {
                if (isFolderOfTabType(folderDTO.type)) {
                    tabsToMessages.set(formatTabNameIfNeeded(folderDTO.name!!), YSSet<MessageId>())
                }
                folderToMessages.set(formatTabNameIfNeeded(folderDTO.name!!), YSSet<MessageId>())
            }
            messageToFolder.__forEach(__LBL__MailboxDownloader_2@ {
                folder, msg ->
                if (isTab(folder)) {
                    tabsToMessages.`get`(formatTabNameIfNeeded(folder))!!.add(msg)
                }
                folderToMessages.`get`(formatTabNameIfNeeded(folder))!!.add(msg)
            })
            val labelToMessages: YSMap<LabelName, YSSet<MessageId>> = mutableMapOf<LabelName, YSSet<MessageId>>()
            for (labelDTO in labelList) {
                labelToMessages.set(labelDTO.name!!, YSSet<MessageId>())
            }
            messageToLabels.__forEach(__LBL__MailboxDownloader_3@ {
                labels, msg ->
                labels.forEach(__LBL__MailboxDownloader_4@ {
                    label ->
                    if (!labelToMessages.has(label)) {
                        labelToMessages.set(label, YSSet())
                    }
                    labelToMessages.`get`(label)!!.add(msg)
                })
            })
            val accountData = AccountMailboxData(client.oauthAccount.account, MessageListDatabase(messages, folderToMessages, labelToMessages, tabsToMessages, valuesArray(threads)), aliases, contacts, accountSettings, zeroSuggest)
            accountsData.add(accountData)
            this.logger.info("Downloading account (${client.oauthAccount.account.login}) finished")
        }
        this.logger.info("Downloading mailbox finished")
        this.logger.info("\n")
        val accountDataHandler = MailAppModelHandler(accountsData)
        return MailboxModel(accountDataHandler)
    }

    private fun getLabelNames(msg: MessageMeta, lidToLabel: YSMap<LabelID, Label>): YSArray<LabelName> {
        val messageLids: YSArray<String> = copyArray(msg.lid)
        return messageLids.map( {
            lid ->
            requireNonNull(undefinedToNull(lidToLabel.`get`(lid)), "Label with lid ${lid} has no label").name!!
        })
    }

}

