// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/base-actions/archive-message-action.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public open class ArchiveMessageAction(private var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContainerGetterFeature.`get`.included(modelFeatures) && ArchiveMessageFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListDisplayModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListDisplayModel.getMessageList(this.order + 1)
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return (currentContainer.type == MessageContainerType.folder && currentContainer.name != DefaultFolderName.archive && this.order < messages.size)
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ArchiveMessageFeature.`get`.forceCast(model).archiveMessage(this.order)
        ArchiveMessageFeature.`get`.forceCast(application).archiveMessage(this.order)
        return history.currentComponent
    }

    open override fun getActionType(): MBTActionType {
        return ArchiveMessageAction.type
    }

    open override fun tostring(): String {
        return "MoveToArchive(#${this.order})"
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.archiveMessage(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ArchiveMessage"
    }
}

