// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/base-actions/delete-message-action.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class BaseDeleteMessageAction protected constructor(protected var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContainerGetterFeature.`get`.included(modelFeatures) && DeleteMessageFeature.`get`.includedAll(modelFeatures, applicationFeatures) && LongSwipeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val actionOnSwipe = GeneralSettingsFeature.`get`.forceCast(model).getActionOnSwipe()
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return (this.order < messages.size && (actionOnSwipe == ActionOnSwipe.delete || currentContainer.name == DefaultFolderName.archive))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        DeleteMessageFeature.`get`.forceCast(model).deleteMessage(this.order)
        DeleteMessageFeature.`get`.forceCast(application).deleteMessage(this.order)
        return MaillistComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.deleteMessage(this.order, fakeMid()))
    }

    open override fun tostring(): String {
        return "DeleteMessageByLongSwipe(#${this.order})"
    }

    abstract override fun getActionType(): MBTActionType
}

public open class DeleteMessageAction(order: Int): BaseDeleteMessageAction(order) {
    open fun performImpl(modelOrApplication: DeleteMessage): Unit {
        return modelOrApplication.deleteMessage(this.order)
    }

    open override fun getActionType(): MBTActionType {
        return DeleteMessageAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteMessage"
    }
}

