// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/base-actions/markable-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class BaseMarkAction protected constructor(protected var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && MarkableReadFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val canPerform = this.canBePerformedImpl(messages[this.order])
        return this.order < messages.size && canPerform
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(MarkableReadFeature.`get`.forceCast(model))
        this.performImpl(MarkableReadFeature.`get`.forceCast(application))
        return history.currentComponent
    }

    abstract override fun events(): YSArray<EventusEvent>
    abstract fun canBePerformedImpl(message: MessageView): Boolean
    abstract fun performImpl(modelOrApplication: MarkableRead): Unit
    abstract override fun tostring(): String
    abstract override fun getActionType(): MBTActionType
}

public open class MarkAsRead(order: Int): BaseMarkAction(order) {
    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsRead.canMarkRead(message)
    }

    open override fun performImpl(modelOrApplication: MarkableRead): Unit {
        return modelOrApplication.markAsRead(this.order)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.markMessageAsRead(this.order, int64(-1)))
    }

    open override fun tostring(): String {
        return "MarkAsRead(#${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsRead.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsRead"
        @JvmStatic
        open fun canMarkRead(message: MessageView): Boolean {
            return !message.read
        }

    }
}

public open class MarkAsUnread(order: Int): BaseMarkAction(order) {
    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsUnread.canMarkUnread(message)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.markMessageAsUnread(this.order, int64(-1)))
    }

    open override fun performImpl(modelOrApplication: MarkableRead): Unit {
        return modelOrApplication.markAsUnread(this.order)
    }

    open override fun tostring(): String {
        return "MarkAsUnread(#${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsUnread.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnread"
        @JvmStatic
        open fun canMarkUnread(message: MessageView): Boolean {
            return message.read
        }

    }
}

