// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/base-actions/spamable-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class BaseSpamAction protected constructor(protected var order: Int, private var type: MBTActionType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContainerGetterFeature.`get`.included(modelFeatures) && SpamableFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListDisplayModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListDisplayModel.getMessageList(this.order + 1)
        val canPerform = this.canBePerformedImpl(model)
        return messages.size > this.order && canPerform
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(SpamableFeature.`get`.forceCast(model))
        this.performImpl(SpamableFeature.`get`.forceCast(application))
        return history.currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)))
    }

    open override fun getActionType(): MBTActionType {
        return this.type
    }

    abstract fun performImpl(modelOrApplication: Spamable): Unit
    abstract fun canBePerformedImpl(model: App): Boolean
    abstract override fun tostring(): String
}

public open class MoveFromSpamAction(order: Int): BaseSpamAction(order, MoveFromSpamAction.type) {
    open override fun getActionType(): MBTActionType {
        return MoveFromSpamAction.type
    }

    open override fun performImpl(modelOrApplication: Spamable): Unit {
        modelOrApplication.moveFromSpam(this.order)
    }

    open override fun tostring(): String {
        return "${MoveFromSpamAction.type}(#${this.order})"
    }

    open override fun events(): YSArray<EventusEvent> {
        val events = super.events()
        events.add(Eventus.messageListEvents.markMessageAsSpam(this.order, int64(-1)))
        return events
    }

    open override fun canBePerformedImpl(model: App): Boolean {
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return currentContainer.type == MessageContainerType.folder && currentContainer.name == DefaultFolderName.spam
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MoveFromSpam"
    }
}

public open class MoveToSpamAction(order: Int): BaseSpamAction(order, MoveToSpamAction.type) {
    open override fun getActionType(): MBTActionType {
        return MoveToSpamAction.type
    }

    open override fun performImpl(modelOrApplication: Spamable): Unit {
        modelOrApplication.moveToSpam(this.order)
    }

    open override fun tostring(): String {
        return "${MoveToSpamAction.type}(#${this.order})"
    }

    open override fun events(): YSArray<EventusEvent> {
        val events = super.events()
        events.add(Eventus.messageListEvents.markMessageAsNotSpam(this.order, int64(-1)))
        return events
    }

    open override fun canBePerformedImpl(model: App): Boolean {
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return currentContainer.type == MessageContainerType.folder && currentContainer.name != DefaultFolderName.spam
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MoveToSpam"
    }
}

