// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/compose/compose-message-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.BaseSimpleAction
import com.yandex.xplat.testopithecus.common.Feature
import com.yandex.xplat.testopithecus.common.MBTActionType
import com.yandex.xplat.testopithecus.common.MBTComponent

public abstract class ComposeMessageBaseAction(type: MBTActionType): BaseSimpleAction<ComposeMessage, MBTComponent>(type) {
    open override fun requiredFeature(): Feature<ComposeMessage> {
        return ComposeMessageFeature.`get`
    }

    abstract override fun events(): YSArray<EventusEvent>
}

public open class AddToAction(private var to: MBTActionType): ComposeMessageBaseAction(AddToAction.type) {
    open override fun performImpl(modelOrApplication: ComposeMessage, currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.addTo(this.to)
        return currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.composeEvents.addReceiver())
    }

    open override fun tostring(): String {
        return "AddToAction(to=${this.to})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "AddTo"
    }
}

public open class SetSubjectAction(private var subject: MBTActionType): ComposeMessageBaseAction(SetSubjectAction.type) {
    open override fun performImpl(modelOrApplication: ComposeMessage, currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.setSubject(this.subject)
        return currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.composeEvents.setSubject())
    }

    open override fun tostring(): String {
        return "AddSubjectAction(subject=${this.subject})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SetSubject"
    }
}

public open class SetBodyAction(private var body: MBTActionType): ComposeMessageBaseAction(SetBodyAction.type) {
    open override fun performImpl(modelOrApplication: ComposeMessage, currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.setBody(this.body)
        return currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.composeEvents.editBody(this.body.length))
    }

    open override fun tostring(): String {
        return "AppendBodyAction(bodyFragment=${this.body})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SetBody"
    }
}

public open class AddToFromSuggestAction(private var to: MBTActionType): ComposeMessageBaseAction(AddToFromSuggestAction.type) {
    open override fun performImpl(modelOrApplication: ComposeMessage, currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.addToUsingSuggest(this.to)
        return currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.composeEvents.addReceiver())
    }

    open override fun tostring(): String {
        return "AddToFromSuggestAction(to=${this.to})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "AddToFromSuggest"
    }
}

