// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/left-column/manage-folders-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public open class DeleteFolderAction(private var folderName: FolderName, private var parentFolders: YSArray<FolderName> = mutableListOf(), private var deletionMethod: ContainerDeletionMethod = ContainerDeletionMethod.tap): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        val folderNavigatorModel = FolderNavigatorFeature.`get`.forceCast(model)
        val folders = folderNavigatorModel.getFoldersList()
        return folders.contains(this.folderName)
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).deleteFolder(this.folderName, this.parentFolders, this.deletionMethod)
        ManageableFolderFeature.`get`.forceCast(application).deleteFolder(this.folderName, this.parentFolders, this.deletionMethod)
        return history.currentComponent
    }

    open override fun getActionType(): MBTActionType {
        return DeleteFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "Delete folder ${this.folderName} by ${this.deletionMethod}"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteFolder"
    }
}

public open class SelectParentFolderAction(private var parentFolder: YSArray<FolderName>): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).selectParentFolder(this.parentFolder)
        ManageableFolderFeature.`get`.forceCast(application).selectParentFolder(this.parentFolder)
        return requireNonNull(history.previousDifferentComponent, "There is no previous screen")
    }

    open override fun getActionType(): MBTActionType {
        return SelectParentFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "SelectParentFolder"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SelectParentFolder"
    }
}

public open class CloseFolderLocationScreenAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).closeFolderLocationScreen()
        ManageableFolderFeature.`get`.forceCast(application).closeFolderLocationScreen()
        return requireNonNull(history.previousDifferentComponent, "There is no previous screen")
    }

    open override fun getActionType(): MBTActionType {
        return CloseFolderLocationScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "CloseFolderLocationScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CloseFolderLocationScreen"
    }
}

public open class OpenFolderLocationScreenAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).openFolderLocationScreen()
        ManageableFolderFeature.`get`.forceCast(application).openFolderLocationScreen()
        return SelectParentFolderComponent()
    }

    open override fun getActionType(): MBTActionType {
        return OpenFolderLocationScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "OpenFolderLocationScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenFolderLocationScreen"
    }
}

public open class SubmitEditedFolderAction: MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).submitEditedFolder()
        ManageableFolderFeature.`get`.forceCast(application).submitEditedFolder()
        return ManageFoldersComponent()
    }

    open override fun getActionType(): MBTActionType {
        return SubmitEditedFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "SubmitEditedFolder"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SubmitEditedFolder"
    }
}

public open class EnterNameForEditedFolderAction(private var folderName: FolderName): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).enterNameForEditedFolder(this.folderName)
        ManageableFolderFeature.`get`.forceCast(application).enterNameForEditedFolder(this.folderName)
        return history.currentComponent
    }

    open override fun getActionType(): MBTActionType {
        return EnterNameForEditedFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "EnterNameForEditedFolder"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "EnterNameForEditedFolder"
    }
}

public open class CloseEditFolderScreenAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).closeEditFolderScreen()
        ManageableFolderFeature.`get`.forceCast(application).closeEditFolderScreen()
        return ManageFoldersComponent()
    }

    open override fun getActionType(): MBTActionType {
        return CloseEditFolderScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "CloseEditFolderScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CloseEditFolderScreen"
    }
}

public open class OpenEditFolderScreenAction(private var folderName: FolderName, private var parentFolders: YSArray<FolderName> = mutableListOf()): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        val folderNavigatorModel = FolderNavigatorFeature.`get`.forceCast(model)
        val folders = folderNavigatorModel.getFoldersList()
        return folders.contains(formatFolderName(this.folderName, this.parentFolders))
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).openEditFolderScreen(this.folderName, this.parentFolders)
        ManageableFolderFeature.`get`.forceCast(application).openEditFolderScreen(this.folderName, this.parentFolders)
        return EditFolderComponent()
    }

    open override fun getActionType(): MBTActionType {
        return OpenEditFolderScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "OpenEditFolderScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenEditFolderScreen"
    }
}

public open class SubmitNewFolderAction: MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).submitNewFolder()
        ManageableFolderFeature.`get`.forceCast(application).submitNewFolder()
        return ManageFoldersComponent()
    }

    open override fun getActionType(): MBTActionType {
        return SubmitNewFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "SubmitNewFolder"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SubmitNewFolder"
    }
}

public open class EnterNameForNewFolderAction(private var folderName: FolderName): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).enterNameForNewFolder(this.folderName)
        ManageableFolderFeature.`get`.forceCast(application).enterNameForNewFolder(this.folderName)
        return history.currentComponent
    }

    open override fun getActionType(): MBTActionType {
        return EnterNameForNewFolderAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "EnterNameForNewFolder"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "EnterNameForNewFolder"
    }
}

public open class CloseCreateFolderScreenAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).closeCreateFolderScreen()
        ManageableFolderFeature.`get`.forceCast(application).closeCreateFolderScreen()
        return ManageFoldersComponent()
    }

    open override fun getActionType(): MBTActionType {
        return CloseCreateFolderScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "CloseCreateFolderScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CloseCreateFolderScreen"
    }
}

public open class OpenCreateFolderScreenAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).openCreateFolderScreen()
        ManageableFolderFeature.`get`.forceCast(application).openCreateFolderScreen()
        return CreateFolderComponent()
    }

    open override fun getActionType(): MBTActionType {
        return OpenCreateFolderScreenAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "OpenCreateFolderScreen"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenCreateFolderScreen"
    }
}

public open class OpenFolderManagerAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).openFolderManager()
        ManageableFolderFeature.`get`.forceCast(application).openFolderManager()
        return ManageFoldersComponent()
    }

    open override fun getActionType(): MBTActionType {
        return OpenFolderManagerAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "OpenFolderManager"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenFolderManager"
    }
}

public open class CloseFolderManagerAction(): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ManageableFolderFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ManageableFolderFeature.`get`.forceCast(model).closeFolderManager()
        ManageableFolderFeature.`get`.forceCast(application).closeFolderManager()
        return FolderListComponent()
    }

    open override fun getActionType(): MBTActionType {
        return CloseFolderManagerAction.type
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "CloseFolderManager"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CloseFolderManager"
    }
}

