// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/login/login-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class LoginAction<T> protected constructor(protected var account: UserAccount, protected var feature: Feature<T>): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return this.feature.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.startEvents.startWithMessageListShow())
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(this.feature.forceCast(model))
        this.performImpl(this.feature.forceCast(application))
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return "${this.getActionType()}(login=${this.account.login}, password=${this.account.password})"
    }

    abstract override fun getActionType(): String
    abstract fun performImpl(modelOrApplication: T): Unit
}

public open class YandexLoginAction(account: UserAccount): LoginAction<YandexLogin>(account, YandexLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: YandexLogin): Unit {
        modelOrApplication.loginWithYandexAccount(this.account)
    }

    open override fun getActionType(): String {
        return YandexLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "YandexLogin"
    }
}

public open class YandexTeamLoginAction(account: UserAccount): LoginAction<YandexTeamLogin>(account, YandexTeamLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: YandexTeamLogin): Unit {
        modelOrApplication.loginWithYandexTeamAccount(this.account)
    }

    open override fun getActionType(): String {
        return YandexTeamLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "YandexTeamLogin"
    }
}

public open class MailRuLoginAction(account: UserAccount): LoginAction<MailRuLogin>(account, MailRuLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: MailRuLogin): Unit {
        modelOrApplication.loginWithMailRuAccount(this.account)
    }

    open override fun getActionType(): String {
        return MailRuLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "MailRuLogin"
    }
}

public open class GoogleLoginAction(account: UserAccount): LoginAction<GoogleLogin>(account, GoogleLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: GoogleLogin): Unit {
        modelOrApplication.loginWithGoogleAccount(this.account)
    }

    open override fun getActionType(): String {
        return GoogleLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "GoogleLogin"
    }
}

public open class OutlookLoginAction(account: UserAccount): LoginAction<OutlookLogin>(account, OutlookLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: OutlookLogin): Unit {
        modelOrApplication.loginWithOutlookAccount(this.account)
    }

    open override fun getActionType(): String {
        return OutlookLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "OutlookLogin"
    }
}

public open class HotmailLoginAction(account: UserAccount): LoginAction<HotmailLogin>(account, HotmailLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: HotmailLogin): Unit {
        modelOrApplication.loginWithHotmailAccount(this.account)
    }

    open override fun getActionType(): String {
        return HotmailLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "HotmailLogin"
    }
}

public open class RamblerlLoginAction(account: UserAccount): LoginAction<RamblerLogin>(account, RamblerLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: RamblerLogin): Unit {
        modelOrApplication.loginWithRamblerAccount(this.account)
    }

    open override fun getActionType(): String {
        return RamblerlLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "RamblerLogin"
    }
}

public open class YahooLoginAction(account: UserAccount): LoginAction<YahooLogin>(account, YahooLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: YahooLogin): Unit {
        modelOrApplication.loginWithYahooAccount(this.account)
    }

    open override fun getActionType(): String {
        return YandexLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "YahooLogin"
    }
}

public open class CustomMailServiceLoginAction(account: UserAccount): LoginAction<CustomMailServiceLogin>(account, CustomMailServiceLoginFeature.`get`) {
    open override fun performImpl(modelOrApplication: CustomMailServiceLogin): Unit {
        modelOrApplication.loginWithCustomMailServiceAccount(this.account)
    }

    open override fun getActionType(): String {
        return CustomMailServiceLoginAction.type
    }

    companion object {
        @JvmStatic val type: String = "CustomMailServiceLogin"
    }
}

public fun loginAction(account: UserAccount, accountType: AccountType2): MBTAction {
    when (accountType) {
        AccountType2.Yandex -> {
            return YandexLoginAction(account)
        }
        AccountType2.YandexTeam -> {
            return YandexTeamLoginAction(account)
        }
        AccountType2.Google -> {
            return GoogleLoginAction(account)
        }
        AccountType2.Hotmail -> {
            return HotmailLoginAction(account)
        }
        AccountType2.Mail -> {
            return MailRuLoginAction(account)
        }
        AccountType2.Outlook -> {
            return OutlookLoginAction(account)
        }
        AccountType2.Rambler -> {
            return RamblerlLoginAction(account)
        }
        AccountType2.Yahoo -> {
            return YahooLoginAction(account)
        }
        AccountType2.Other -> {
            return CustomMailServiceLoginAction(account)
        }
        else -> {
            throw Error("Unsupported account type: " + accountType.toString())
        }
    }
}

public open class ChoseAccountFromAccountsListAction(private var account: UserAccount): MBTAction {
    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountsListFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        AccountsListFeature.`get`.forceCast(model).choseAccountFromAccountsList(this.account)
        AccountsListFeature.`get`.forceCast(application).choseAccountFromAccountsList(this.account)
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return "Chose account from accounts list"
    }

    open override fun getActionType(): MBTActionType {
        return ChoseAccountFromAccountsListAction.type
    }

    companion object {
        @JvmStatic val type: String = "ChoseAccountFromAccountsList"
    }
}

public open class RevokeTokenForAccount(private var account: UserAccount): MBTAction {
    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountsListFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ExpiringTokenFeature.`get`.forceCast(model).revokeToken(this.account)
        ExpiringTokenFeature.`get`.forceCast(application).revokeToken(this.account)
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return "RevokeTokenForAccount"
    }

    open override fun getActionType(): MBTActionType {
        return RevokeTokenForAccount.type
    }

    companion object {
        @JvmStatic val type: String = "RevokeTokenForAccount"
    }
}

