// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/login/multi-account-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class MultiAccountAction protected constructor(): MBTAction {
    abstract override fun events(): YSArray<EventusEvent>
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return MultiAccountFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    abstract override fun perform(model: App, application: App, history: MBTHistory): MBTComponent
    abstract override fun canBePerformed(model: App): Boolean
    abstract override fun tostring(): String
    abstract override fun getActionType(): String
}

public open class SwitchAccountAction(private var account: UserAccount): MultiAccountAction() {
    open override fun canBePerformed(model: App): Boolean {
        return MultiAccountFeature.`get`.forceCast(model).getLoggedInAccountsList().contains(this.account.login)
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return "SwitchAccountAction(login=${this.account.login})"
    }

    open override fun getActionType(): String {
        return SwitchAccountAction.type
    }

    private fun performImpl(modelOrApplication: App): Unit {
        MultiAccountFeature.`get`.forceCast(modelOrApplication).switchToAccount(this.account.login)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.multiAccountEvents.switchToAccount(int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SwitchAccount"
    }
}

public open class AddNewAccountAction(): MultiAccountAction() {
    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return LoginComponent()
    }

    open override fun tostring(): String {
        return "AddNewAccountAction"
    }

    open override fun getActionType(): String {
        return AddNewAccountAction.type
    }

    private fun performImpl(modelOrApplication: App): Unit {
        MultiAccountFeature.`get`.forceCast(modelOrApplication).addNewAccount()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.multiAccountEvents.addNewAccount())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "AddNewAccount"
    }
}

public open class LogoutFromAccountAction(private var account: UserAccount): MultiAccountAction() {
    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return "LogoutFromAccountAction(login=${this.account.login})"
    }

    open override fun getActionType(): String {
        return LogoutFromAccountAction.type
    }

    private fun performImpl(modelOrApplication: App): Unit {
        MultiAccountFeature.`get`.forceCast(modelOrApplication).logoutFromAccount(this.account.login)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.multiAccountEvents.logoutFromAccount())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "LogoutFromAccount"
    }
}

public open class LogoutFromLastAccountAction(private var account: UserAccount): MultiAccountAction() {
    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return LoginComponent()
    }

    open override fun tostring(): String {
        return "LogoutFromAccountAction(login=${this.account.login})"
    }

    open override fun getActionType(): String {
        return LogoutFromAccountAction.type
    }

    private fun performImpl(modelOrApplication: App): Unit {
        MultiAccountFeature.`get`.forceCast(modelOrApplication).logoutFromAccount(this.account.login)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    companion object {
        @JvmStatic val type: MBTActionType = "LogoutFromLastAccount"
    }
}

