// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/messages-list/context-menu-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.filter
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class BaseContextMenuAction protected constructor(protected var order: Int, private var type: MBTActionType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val canPerform = this.canBePerformedImpl(messages[this.order])
        return this.order < messages.size && canPerform
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(ContextMenuFeature.`get`.forceCast(model))
        this.performImpl(ContextMenuFeature.`get`.forceCast(application))
        return history.currentComponent
    }

    open override fun getActionType(): MBTActionType {
        return this.type
    }

    abstract fun canBePerformedImpl(message: MessageView): Boolean
    abstract fun performImpl(modelOrApplication: ContextMenu): Unit
    abstract override fun events(): YSArray<EventusEvent>
    abstract override fun tostring(): String
}

public open class DeleteMessageFromContextMenuAction(order: Int): BaseContextMenuAction(order, DeleteMessageFromContextMenuAction.type) {
    open override fun performImpl(modelOrApplication: ContextMenu): Unit {
        modelOrApplication.deleteMessageFromContextMenu(this.order)
    }

    open override fun tostring(): String {
        return "DeleteMessageFromContextMenu(${this.order})"
    }

    open override fun canBePerformedImpl(_message: MessageView): Boolean {
        return true
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.deleteMessage(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteMessageFromContextMenu"
    }
}

public open class MarkAsSpamFromContextMenuAction(private var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        return ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name != DefaultFolderName.spam
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, fakeMid()), Eventus.messageListEvents.markMessageAsSpam(this.order, fakeMid()))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).markAsSpamFromContextMenu(this.order)
        ContextMenuFeature.`get`.forceCast(application).markAsSpamFromContextMenu(this.order)
        return history.currentComponent
    }

    open override fun tostring(): String {
        return "MarkAsSpamFromContextMenuAction(${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsSpamFromContextMenuAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsSpamFromContextMenuAction"
    }
}

public open class MarkAsNotSpamFromContextMenuAction(private var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        return ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name == DefaultFolderName.spam
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, fakeMid()), Eventus.messageListEvents.markMessageAsNotSpam(this.order, fakeMid()))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).markAsNotSpamFromContextMenu(this.order)
        ContextMenuFeature.`get`.forceCast(application).markAsNotSpamFromContextMenu(this.order)
        return history.currentComponent
    }

    open override fun tostring(): String {
        return "MarkAsNotSpamFromContextMenuAction(${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsNotSpamFromContextMenuAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsNotSpamFromContextMenuAction"
    }
}

public open class ApplyLabelsFromContextMenuAction(private var order: Int, private var labelNames: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return !mutableListOf(DefaultFolderName.spam, DefaultFolderName.trash).contains(ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, fakeMid()), Eventus.messageListEvents.markMessageAs(this.order, fakeMid()))
    }

    open override fun getActionType(): String {
        return ApplyLabelsFromContextMenuAction.type
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).applyLabelsFromContextMenu(this.order, this.labelNames)
        ContextMenuFeature.`get`.forceCast(application).applyLabelsFromContextMenu(this.order, this.labelNames)
        return history.currentComponent
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${ApplyLabelsFromContextMenuAction.type}(${this.order})(${this.labelNames})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ApplyLabelsFromContextMenuAction"
    }
}

public open class RemoveLabelsFromContextMenuAction(private var order: Int, private var labelNames: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return !mutableListOf(DefaultFolderName.spam, DefaultFolderName.trash).contains(ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, fakeMid()), Eventus.messageListEvents.markMessageAs(this.order, fakeMid()))
    }

    open override fun getActionType(): String {
        return RemoveLabelsFromContextMenuAction.type
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).removeLabelsFromContextMenu(this.order, this.labelNames)
        ContextMenuFeature.`get`.forceCast(application).removeLabelsFromContextMenu(this.order, this.labelNames)
        return history.currentComponent
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${RemoveLabelsFromContextMenuAction.type}(${this.order})(${this.labelNames})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "RemoveLabelsFromContextMenuAction"
    }
}

public open class OpenReplyComposeFromContextMenuAction(private var order: Int): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return !mutableListOf(DefaultFolderName.draft, DefaultFolderName.template).contains(ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, fakeMid()), Eventus.messageListEvents.replyMessage(this.order, fakeMid()))
    }

    open override fun getActionType(): String {
        return OpenReplyComposeFromContextMenuAction.type
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).openReplyComposeFromContextMenu(this.order)
        ContextMenuFeature.`get`.forceCast(application).openReplyComposeFromContextMenu(this.order)
        return ComposeComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ComposeMessageFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${OpenReplyComposeFromContextMenuAction.type}(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenReplyComposeFromContextMenuAction"
    }
}

public open class MarkAsReadFromContextMenuAction(order: Int): BaseContextMenuAction(order, MarkAsReadFromContextMenuAction.type) {
    open override fun performImpl(modelOrApplication: ContextMenu): Unit {
        modelOrApplication.markAsReadFromContextMenu(this.order)
    }

    open override fun tostring(): String {
        return "MarkAsReadFromContextMenu(${this.order})"
    }

    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsRead.canMarkRead(message)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.markMessageAsRead(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsReadFromContextMenu"
    }
}

public open class MarkAsUnreadFromContextMenuAction(order: Int): BaseContextMenuAction(order, MarkAsUnreadFromContextMenuAction.type) {
    open override fun performImpl(modelOrApplication: ContextMenu): Unit {
        modelOrApplication.markAsUnreadFromContextMenu(this.order)
    }

    open override fun tostring(): String {
        return "MarkAsUnreadFromContextMenuAction(${this.order})"
    }

    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsUnread.canMarkUnread(message)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.markMessageAsUnread(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnreadFromContextMenu"
    }
}

public open class MarkAsImportantFromContextMenuAction(order: Int): BaseContextMenuAction(order, MarkAsImportantFromContextMenuAction.type) {
    open override fun performImpl(modelOrApplication: ContextMenu): Unit {
        modelOrApplication.markAsImportantFromContextMenu(this.order)
    }

    open override fun tostring(): String {
        return "MarkAsImportantFromContextMenuAction(${this.order})"
    }

    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsImportant.canMarkImportant(message)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.markMessageAsImportant(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsImportantFromContextMenu"
    }
}

public open class MarkAsUnImportantFromContextMenuAction(order: Int): BaseContextMenuAction(order, MarkAsUnImportantFromContextMenuAction.type) {
    open override fun performImpl(modelOrApplication: ContextMenu): Unit {
        modelOrApplication.markAsUnImportantFromContextMenu(this.order)
    }

    open override fun tostring(): String {
        return "MarkAsUnImportantFromContextMenuAction(${this.order})"
    }

    open override fun canBePerformedImpl(message: MessageView): Boolean {
        return MarkAsUnimportant.canMarkUnimportant(message)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.markMessageAsNotImportant(this.order, int64(-1)))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnImportantFromContextMenuAction"
    }
}

public open class MoveToFolderFromContextMenuAction(private var order: Int, private var folderName: String): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (FolderNavigatorFeature.`get`.included(modelFeatures) && MovableToFolderFeature.`get`.included(modelFeatures) && ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val folderNavigatorModel = FolderNavigatorFeature.`get`.forceCast(model)
        val folders = folderNavigatorModel.getFoldersList()
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return (folders.filter( {
            folder ->
            folder == this.folderName
        }).size > 0 && (currentContainer.type == MessageContainerType.folder || currentContainer.type == MessageContainerType.search) && currentContainer.name != this.folderName)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.moveMessageToFolder(this.order, int64(-1)))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).moveToFolderFromContextMenu(this.order, this.folderName)
        ContextMenuFeature.`get`.forceCast(application).moveToFolderFromContextMenu(this.order, this.folderName)
        return history.currentComponent
    }

    open override fun tostring(): String {
        return "MovableToFolderFromContextMenuAction(${this.order} ${this.folderName})"
    }

    open override fun getActionType(): MBTActionType {
        return MoveToFolderFromContextMenuAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MoveToFolderFromContextMenu"
    }
}

public open class ArchiveFromContextMenuAction(private var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (ContainerGetterFeature.`get`.included(modelFeatures) && ContextMenuFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val isInArchiveFolder = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name == DefaultFolderName.archive
        return this.order < messages.size && !isInArchiveFolder
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessageActions(this.order, int64(-1)), Eventus.messageListEvents.archiveMessage(this.order, int64(-1)))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ContextMenuFeature.`get`.forceCast(model).archiveFromContextMenu(this.order)
        ContextMenuFeature.`get`.forceCast(application).archiveFromContextMenu(this.order)
        return history.currentComponent
    }

    open override fun tostring(): String {
        return "ArchiveFromContextMenuAction(${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return ArchiveFromContextMenuAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ArchiveFromContextMenu"
    }
}

