// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/messages-list/group-mode-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class BaseGroupModeAction(private var type: MBTActionType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures) && ContainerGetterFeature.`get`.included(modelFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val groupModeModel = GroupModeFeature.`get`.forceCast(model)
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val containersModel = ContainerGetterFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val selectedMessageOrders = groupModeModel.getSelectedMessages()
        if (selectedMessageOrders == null) {
            return false
        }
        val selectedMessages: YSArray<MessageView> = mutableListOf()
        for (order in selectedMessageOrders.values()) {
            selectedMessages.add(messages[order])
        }
        val currentContainer = containersModel.getCurrentContainer()
        if (currentContainer.type != MessageContainerType.folder) {
            return false
        }
        return this.canBePerformedImpl(selectedMessages, selectedMessageOrders, requireNonNull(currentContainer.name, "Мы не находимся в папке"))
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(GroupModeFeature.`get`.forceCast(model))
        this.performImpl(GroupModeFeature.`get`.forceCast(application))
        return MaillistComponent()
    }

    open override fun getActionType(): MBTActionType {
        return this.type
    }

    abstract fun canBePerformedImpl(messages: YSArray<MessageView>, selectedOrders: YSSet<Int>, currentFolder: FolderName): Boolean
    abstract fun performImpl(modelOrApplication: GroupMode): Unit
    abstract override fun events(): YSArray<EventusEvent>
    abstract override fun tostring(): String
}

public abstract class BaseMarkSelectedMessages(private var type: MBTActionType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val groupModeModel = GroupModeFeature.`get`.forceCast(model)
        val selectedMessageOrders = groupModeModel.getSelectedMessages()
        if (selectedMessageOrders == null) {
            return false
        }
        val messages = messageListModel.getMessageList(10)
        val unreadCount = filterByOrders(messages, selectedMessageOrders).filter( {
            message ->
            !message.read
        }).size
        return this.canBePerformedImpl(unreadCount)
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        this.performImpl(GroupModeFeature.`get`.forceCast(model))
        this.performImpl(GroupModeFeature.`get`.forceCast(application))
        return MaillistComponent()
    }

    open override fun tostring(): String {
        return this.getActionType()
    }

    open override fun getActionType(): MBTActionType {
        return this.type
    }

    abstract override fun events(): YSArray<EventusEvent>
    abstract fun canBePerformedImpl(selectedUnreadCount: Int): Boolean
    abstract fun performImpl(modelOrApplication: GroupMode): Unit
}

public open class InitialSelectMessage(private var order: Int): BaseSimpleAction<GroupMode, MaillistComponent>(SelectMessage.type) {
    open override fun requiredFeature(): Feature<GroupMode> {
        return GroupModeFeature.`get`
    }

    open override fun canBePerformedImpl(model: GroupMode): Boolean {
        val isInGroupMode = model.isInGroupMode()
        return !isInGroupMode
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.selectMessage(this.order, int64(-1)))
    }

    open override fun performImpl(modelOrApplication: GroupMode, _currentComponent: MaillistComponent): MBTComponent {
        modelOrApplication.initialMessageSelect(this.order)
        return GroupOperationsComponent()
    }

    open override fun tostring(): String {
        return "InitialSelectMessage(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "InitialSelectMessages"
    }
}

public open class SelectMessage(private var order: Int): BaseSimpleAction<GroupMode, GroupOperationsComponent>(SelectMessage.type) {
    open override fun requiredFeature(): Feature<GroupMode> {
        return GroupModeFeature.`get`
    }

    open override fun canBePerformedImpl(model: GroupMode): Boolean {
        return model.isInGroupMode()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.selectMessage(this.order, int64(-1)))
    }

    open override fun performImpl(modelOrApplication: GroupMode, _currentComponent: GroupOperationsComponent): MBTComponent {
        modelOrApplication.selectMessage(this.order)
        return GroupOperationsComponent()
    }

    open override fun tostring(): String {
        return "SelectMessages(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SelectMessages"
    }
}

public open class SelectAllMessages(): BaseSimpleAction<GroupMode, GroupOperationsComponent>(SelectAllMessages.type) {
    open override fun requiredFeature(): Feature<GroupMode> {
        return GroupModeFeature.`get`
    }

    open override fun canBePerformedImpl(model: GroupMode): Boolean {
        return model.isInGroupMode()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun performImpl(modelOrApplication: GroupMode, _currentComponent: GroupOperationsComponent): MBTComponent {
        modelOrApplication.selectAllMessages()
        return GroupOperationsComponent()
    }

    open override fun tostring(): String {
        return "SelectAllMessages"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SelectAllMessages"
    }
}

public open class MarkAsReadSelectedMessages(): BaseMarkSelectedMessages(MarkAsReadSelectedMessages.type) {
    open override fun canBePerformedImpl(selectedUnreadCount: Int): Boolean {
        return selectedUnreadCount > 0
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsReadSelectedMessages()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.markAsReadSelectedMessages())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsReadSelectedMessages"
    }
}

public open class MarkAsUnreadSelectedMessages(): BaseMarkSelectedMessages(MarkAsUnreadSelectedMessages.type) {
    open override fun canBePerformedImpl(selectedUnreadCount: Int): Boolean {
        return selectedUnreadCount == 0
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsUnreadSelectedMessages()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.markAsUnreadSelectedMessages())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnreadSelectedMessages"
    }
}

public open class DeleteSelectedMessages: MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        GroupModeFeature.`get`.forceCast(model).deleteSelectedMessages()
        GroupModeFeature.`get`.forceCast(application).deleteSelectedMessages()
        return MaillistComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.deleteSelectedMessages())
    }

    open override fun tostring(): String {
        return this.getActionType()
    }

    open override fun getActionType(): MBTActionType {
        return DeleteSelectedMessages.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteSelectedMessages"
    }
}

public open class ArchiveSelectedMessages: MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        return ContainerGetterFeature.`get`.castIfSupported(model)!!.getCurrentContainer().name != DefaultFolderName.archive
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        GroupModeFeature.`get`.forceCast(model).archiveSelectedMessages()
        GroupModeFeature.`get`.forceCast(application).archiveSelectedMessages()
        return MaillistComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return this.getActionType()
    }

    open override fun getActionType(): MBTActionType {
        return ArchiveSelectedMessages.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ArchiveSelectedMessages"
    }
}

public open class MarkImportantSelectedAction(): BaseGroupModeAction(MarkImportantSelectedAction.type) {
    open override fun canBePerformedImpl(messages: YSArray<MessageView>, _selectedOrders: YSSet<Int>, _currentFolder: FolderName): Boolean {
        return messages.map( {
            m ->
            !m.important
        }).contains(true)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsImportantSelectedMessages()
    }

    open override fun tostring(): String {
        return MarkImportantSelectedAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkImportantSelected"
    }
}

public open class MarkUnimportantSelectedAction(): BaseGroupModeAction(MarkUnimportantSelectedAction.type) {
    open override fun canBePerformedImpl(messages: YSArray<MessageView>, _selectedOrders: YSSet<Int>, _currentFolder: FolderName): Boolean {
        return messages.map( {
            m ->
            !m.important
        }).contains(false)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsUnImportantSelectedMessages()
    }

    open override fun tostring(): String {
        return MarkUnimportantSelectedAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkUnimportantSelected"
    }
}

public open class MarkSpamSelectedAction(): BaseGroupModeAction(MarkSpamSelectedAction.type) {
    open override fun canBePerformedImpl(messages: YSArray<MessageView>, selectedOrders: YSSet<Int>, currentFolder: FolderName): Boolean {
        return currentFolder != DefaultFolderName.spam
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsSpamSelectedMessages()
    }

    open override fun tostring(): String {
        return MarkSpamSelectedAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkSpamSelected"
    }
}

public open class MarkNotSpamSelectedAction(): BaseGroupModeAction(MarkNotSpamSelectedAction.type) {
    open override fun canBePerformedImpl(messages: YSArray<MessageView>, selectedOrders: YSSet<Int>, currentFolder: FolderName): Boolean {
        return currentFolder == DefaultFolderName.spam
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.markAsNotSpamSelectedMessages()
    }

    open override fun tostring(): String {
        return MarkNotSpamSelectedAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkNotSpamSelected"
    }
}

public open class MoveToFolderSelectedMessagesAction(private var folderName: FolderName): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        val currentContainer = ContainerGetterFeature.`get`.castIfSupported(model)!!.getCurrentContainer()
        return currentContainer.type == MessageContainerType.folder && currentContainer.name != this.folderName
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): String {
        return MoveToFolderSelectedMessagesAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        GroupModeFeature.`get`.forceCast(model).moveToFolderSelectedMessages(this.folderName)
        GroupModeFeature.`get`.forceCast(application).moveToFolderSelectedMessages(this.folderName)
        return MaillistComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${MoveToFolderSelectedMessagesAction.type}(${this.folderName})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MoveToFolderSelectedMessages"
    }
}

public open class ApplyLabelsToSelectedMessagesAction(private var labelNames: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return !mutableListOf(DefaultFolderName.spam, DefaultFolderName.trash).contains(ContainerGetterFeature.`get`.castIfSupported(model)!!.getCurrentContainer().name)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): String {
        return ApplyLabelsToSelectedMessagesAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        GroupModeFeature.`get`.forceCast(model).applyLabelsToSelectedMessages(this.labelNames)
        GroupModeFeature.`get`.forceCast(application).applyLabelsToSelectedMessages(this.labelNames)
        return MaillistComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${ApplyLabelsToSelectedMessagesAction.type}(${this.labelNames})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ApplyLabelsToSelectedMessagesAction"
    }
}

public open class RemoveLabelsFromSelectedMessagesAction(private var labelNames: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        return !mutableListOf(DefaultFolderName.spam, DefaultFolderName.trash).contains(ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer().name)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): String {
        return RemoveLabelsFromSelectedMessagesAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        GroupModeFeature.`get`.forceCast(model).removeLabelsFromSelectedMessages(this.labelNames)
        GroupModeFeature.`get`.forceCast(application).removeLabelsFromSelectedMessages(this.labelNames)
        return MaillistComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && GroupModeFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun tostring(): String {
        return "${RemoveLabelsFromSelectedMessagesAction.type}(${this.labelNames})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "RemoveLabelsFromSelectedMessagesAction"
    }
}

public open class UnselectMessageAction(private var order: Int): BaseGroupModeAction(UnselectMessageAction.type) {
    open override fun canBePerformedImpl(messages: YSArray<MessageView>, selectedOrders: YSSet<Int>, _currentFolder: FolderName): Boolean {
        return selectedOrders.has(this.order)
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.groupActionsEvents.deselectMessage(this.order, fakeMid()))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(GroupModeFeature.`get`.forceCast(model))
        this.performImpl(GroupModeFeature.`get`.forceCast(application))
        if (GroupModeFeature.`get`.forceCast(model).isInGroupMode()) {
            return history.currentComponent
        } else {
            return MaillistComponent()
        }
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.unselectMessage(this.order)
    }

    open override fun tostring(): String {
        return "${UnselectMessageAction.type}(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "UnselectMessages"
    }
}

public open class UnselectAllMessagesAction(): BaseGroupModeAction(UnselectAllMessagesAction.type) {
    open fun requiredFeature(): Feature<GroupMode> {
        return GroupModeFeature.`get`
    }

    open override fun canBePerformedImpl(messages: YSArray<MessageView>, selectedOrders: YSSet<Int>, _currentFolder: FolderName): Boolean {
        return selectedOrders.size >= 1
    }

    open override fun performImpl(modelOrApplication: GroupMode): Unit {
        modelOrApplication.unselectAllMessages()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return UnselectAllMessagesAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "UnselectAllMessages"
    }
}

