// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/messages-list/short-swipe-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public open class DeleteMessageByShortSwipeAction(protected var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ShortSwipeFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val actionOnSwipe = GeneralSettingsFeature.`get`.forceCast(model).getActionOnSwipe()
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return (this.order < messages.size && (actionOnSwipe == ActionOnSwipe.delete || currentContainer.name == DefaultFolderName.archive))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ShortSwipeFeature.`get`.forceCast(model).deleteMessageByShortSwipe(this.order)
        ShortSwipeFeature.`get`.forceCast(application).deleteMessageByShortSwipe(this.order)
        return history.currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.deleteMessage(this.order, fakeMid()))
    }

    open override fun getActionType(): MBTActionType {
        return DeleteMessageByShortSwipeAction.type
    }

    open override fun tostring(): String {
        return "DeleteMessageByShortSwipeAction(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteMessageByShortSwipeAction"
    }
}

public open class ArchiveMessageByShortSwipeAction(protected var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ShortSwipeFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        val actionOnSwipe = GeneralSettingsFeature.`get`.forceCast(model).getActionOnSwipe()
        val currentContainer = ContainerGetterFeature.`get`.forceCast(model).getCurrentContainer()
        return (this.order < messages.size && actionOnSwipe == ActionOnSwipe.archive && (currentContainer.type == MessageContainerType.folder || currentContainer.type == MessageContainerType.search) && currentContainer.name != DefaultFolderName.archive)
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ShortSwipeFeature.`get`.forceCast(model).archiveMessageByShortSwipe(this.order)
        ShortSwipeFeature.`get`.forceCast(application).archiveMessageByShortSwipe(this.order)
        return history.currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): MBTActionType {
        return ArchiveMessageByShortSwipeAction.type
    }

    open override fun tostring(): String {
        return "ArchiveMessageByShortSwipeAction(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ArchiveMessageByShortSwipeAction"
    }
}

public open class MarkAsUnreadFromShortSwipeAction(protected var order: Int): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        return this.order < messages.size && messages[this.order].read
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.markMessageAsUnread(this.order, fakeMid()))
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsUnreadFromShortSwipeAction.type
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ShortSwipeFeature.`get`.forceCast(model).markAsUnread(this.order)
        ShortSwipeFeature.`get`.forceCast(application).markAsUnread(this.order)
        return history.currentComponent
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ShortSwipeFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun tostring(): String {
        return "MarkAsUnreadFromShortSwipeAction(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnreadFromShortSwipeAction"
    }
}

public open class MarkAsReadFromShortSwipeAction(protected var order: Int): MBTAction {
    open override fun canBePerformed(model: App): Boolean {
        val messageListModel = MessageListDisplayFeature.`get`.forceCast(model)
        val messages = messageListModel.getMessageList(10)
        return this.order < messages.size && !messages[this.order].read
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.markMessageAsRead(this.order, fakeMid()))
    }

    open override fun getActionType(): MBTActionType {
        return MarkAsReadFromShortSwipeAction.type
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        ShortSwipeFeature.`get`.forceCast(model).markAsRead(this.order)
        ShortSwipeFeature.`get`.forceCast(application).markAsRead(this.order)
        return history.currentComponent
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return ShortSwipeFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun tostring(): String {
        return "MarkAsReadFromShortSwipeAction(${this.order})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsReadFromShortSwipeAction"
    }
}

