// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/messages-list/thread-markable-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public abstract class AbstractExpandableThreadsAction(protected var threadOrder: Int, private var type: MBTActionType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (ExpandableThreadsModelFeature.`get`.included(modelFeatures) && ExpandableThreadsFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        return this.canBePerformedImpl(ExpandableThreadsModelFeature.`get`.forceCast(model))
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(ExpandableThreadsFeature.`get`.forceCast(model))
        this.performImpl(ExpandableThreadsFeature.`get`.forceCast(application))
        return history.currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): MBTActionType {
        return this.type
    }

    abstract fun canBePerformedImpl(model: ReadOnlyExpandableThreads): Boolean
    abstract fun performImpl(modelOrApplication: ExpandableThreads): Unit
    abstract override fun tostring(): String
}

public open class ExpandThreadAction(threadOrder: Int): AbstractExpandableThreadsAction(threadOrder, ExpandThreadAction.type) {
    open override fun canBePerformedImpl(model: ReadOnlyExpandableThreads): Boolean {
        val isExpanded = model.isExpanded(this.threadOrder)
        val threadLength = model.getMessagesInThread(this.threadOrder).size
        return !isExpanded && threadLength > 1
    }

    open override fun performImpl(modelOrApplication: ExpandableThreads): Unit {
        modelOrApplication.expandThread(this.threadOrder)
    }

    open override fun tostring(): String {
        return "ExpandThreadAction(${this.threadOrder})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ExpandThread"
    }
}

public open class CollapseThreadAction(threadOrder: Int): AbstractExpandableThreadsAction(threadOrder, CollapseThreadAction.type) {
    open override fun canBePerformedImpl(model: ReadOnlyExpandableThreads): Boolean {
        return model.isExpanded(this.threadOrder)
    }

    open override fun performImpl(modelOrApplication: ExpandableThreads): Unit {
        modelOrApplication.collapseThread(this.threadOrder)
    }

    open override fun tostring(): String {
        return "CollapseThreadAction(${this.threadOrder})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CollapseThread"
    }
}

public open class MarkAsReadExpandedAction(threadOrder: Int, private var messageOrder: Int): AbstractExpandableThreadsAction(threadOrder, MarkAsReadExpandedAction.type) {
    open override fun canBePerformedImpl(model: ReadOnlyExpandableThreads): Boolean {
        val isRead = model.isRead(this.threadOrder, this.messageOrder)
        return model.isExpanded(this.threadOrder) && !isRead
    }

    open override fun performImpl(modelOrApplication: ExpandableThreads): Unit {
        modelOrApplication.markThreadMessageAsRead(this.threadOrder, this.messageOrder)
    }

    open override fun tostring(): String {
        return "MarkAsReadExpandedAction(${this.threadOrder}, ${this.messageOrder})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsReadExpanded"
    }
}

public open class MarkAsUnreadExpandedAction(threadOrder: Int, private var messageOrder: Int): AbstractExpandableThreadsAction(threadOrder, MarkAsUnreadExpandedAction.type) {
    open override fun canBePerformedImpl(model: ReadOnlyExpandableThreads): Boolean {
        val isRead = model.isRead(this.threadOrder, this.messageOrder)
        return model.isExpanded(this.threadOrder) && isRead
    }

    open override fun performImpl(modelOrApplication: ExpandableThreads): Unit {
        modelOrApplication.markThreadMessageAsUnRead(this.threadOrder, this.messageOrder)
    }

    open override fun tostring(): String {
        return "MarkAsUnreadExpandedAction(${this.threadOrder}, ${this.messageOrder})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnreadExpanded"
    }
}

