// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/opened-message/message-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.testopithecus.common.*

public open class OpenMessageAction(private var order: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return MessageViewerFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        val isInGroupMode = GroupModeFeature.`get`.castIfSupported(model)!!.isInGroupMode()
        return !isInGroupMode
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        MessageViewerFeature.`get`.forceCast(model).openMessage(this.order)
        MessageViewerFeature.`get`.forceCast(application).openMessage(this.order)
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageListEvents.openMessage(this.order, int64(-1)))
    }

    open override fun tostring(): String {
        return "OpenMessage(${this.order})"
    }

    open override fun getActionType(): MBTActionType {
        return OpenMessageAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenMessage"
    }
}

public open class BackToMaillistFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(BackToMaillistFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.closeMessage()
        return MaillistComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.backToMailList())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "BackToMaillist"
    }
}

public open class CheckIfReadFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(CheckIfReadFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.checkIfRead()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CheckIfRead"
    }
}

public open class MarkAsReadFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(MarkAsReadFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.markAsRead()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsRead())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsRead"
    }
}

public open class MarkAsUnreadFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(MarkAsUnreadFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.markAsUnread()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsUnread())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnread"
    }
}

public open class MarkAsSpamFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(MarkAsSpamFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.markAsSpam()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsSpam())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsSpam"
    }
}

public open class UnmarkAsSpamFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(UnmarkAsSpamFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.unmarkAsSpam()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsNotSpam())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "UnmarkAsSpam"
    }
}

public open class MarkAsImportantFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(MarkAsImportantFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.markAsImportant()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsImportant())
    }

    open override fun canBePerformedImpl(model: MessageViewer): Boolean {
        val isSpam = model.checkIfSpam()
        return !isSpam
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsImportant"
    }
}

public open class MarkAsUnimportantFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(MarkAsUnimportantFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.markAsUnimportant()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAsNotImportant())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MarkAsUnimportant"
    }
}

public open class MoveMessageToFolderFromMessageViewAction(private var folderName: FolderName): MBTAction {
    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.moveToFolder())
    }

    open override fun getActionType(): String {
        return MoveMessageToFolderFromMessageViewAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        MessageViewerFeature.`get`.forceCast(model).moveMessageToFolder(this.folderName)
        MessageViewerFeature.`get`.forceCast(application).moveMessageToFolder(this.folderName)
        return MessageComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return MessageViewerFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun tostring(): String {
        return "MoveToFolder(${this.folderName})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "MoveToFolder"
    }
}

public open class AddLabelsFromMessageViewAction(private var labels: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(_model: App): Boolean {
        return true
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAs())
    }

    open override fun getActionType(): String {
        return AddLabelsFromMessageViewAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        MessageViewerFeature.`get`.forceCast(model).addLabels(this.labels)
        MessageViewerFeature.`get`.forceCast(application).addLabels(this.labels)
        return MessageComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return MessageViewerFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun tostring(): String {
        return "AddLabel${this.labels}"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "AddLabel"
    }
}

public open class DeleteLabelsFromMessageViewAction(private var labels: YSArray<LabelName>): MBTAction {
    open override fun canBePerformed(_model: App): Boolean {
        return this.labels.size > 0
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.markAs())
    }

    open override fun getActionType(): String {
        return DeleteLabelsFromMessageViewAction.type
    }

    open override fun perform(model: App, application: App, _history: MBTHistory): MBTComponent {
        MessageViewerFeature.`get`.forceCast(model).deleteLabels(this.labels)
        MessageViewerFeature.`get`.forceCast(application).deleteLabels(this.labels)
        return MessageComponent()
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return MessageViewerFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun tostring(): String {
        return "DeleteLabel(${this.labels})"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "DeleteLabels"
    }
}

public open class ArchiveFromMessageViewAction(): BaseSimpleAction<MessageViewer, MBTComponent>(ArchiveFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<MessageViewer> {
        return MessageViewerFeature.`get`
    }

    open override fun performImpl(modelOrApplication: MessageViewer, _currentComponent: MBTComponent): MBTComponent {
        modelOrApplication.archive()
        return MessageComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.openMessageActions(0), Eventus.messageActionsEvents.archive())
    }

    companion object {
        @JvmStatic val type: MBTActionType = "Archive"
    }
}

public open class GoToMessageReplyFromMessageViewAction(): BaseSimpleAction<ComposeMessage, MessageComponent>(GoToMessageReplyFromMessageViewAction.type) {
    open override fun requiredFeature(): Feature<ComposeMessage> {
        return ComposeMessageFeature.`get`
    }

    open override fun performImpl(modelOrApplication: ComposeMessage, _currentComponent: MessageComponent): MBTComponent {
        modelOrApplication.goToMessageReply()
        return ComposeComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.messageViewEvents.reply(0))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "GoToMessageReply"
    }
}

