// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/settings/account-settings-actions.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.eventus.Eventus
import com.yandex.xplat.eventus.common.EventusEvent
import com.yandex.xplat.mapi.AccountType
import com.yandex.xplat.testopithecus.common.*

public open class OpenAccountSettingsAction(var accountIndex: Int): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountSettingsFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        AccountSettingsFeature.`get`.forceCast(model).openAccountSettings(this.accountIndex)
        AccountSettingsFeature.`get`.forceCast(application).openAccountSettings(this.accountIndex)
        return AccountSettingsComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.accountSettingsEvents.openAccountSettings())
    }

    open override fun getActionType(): String {
        return OpenAccountSettingsAction.type
    }

    open override fun tostring(): String {
        return "OpenAccountSettings"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "OpenAccountSettings"
    }
}

public open class CloseAccountSettingsAction: MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountSettingsFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        AccountSettingsFeature.`get`.forceCast(model).closeAccountSettings()
        AccountSettingsFeature.`get`.forceCast(application).closeAccountSettings()
        return RootSettingsComponent()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): String {
        return CloseAccountSettingsAction.type
    }

    open override fun tostring(): String {
        return "CloseAccountSettings"
    }

    companion object {
        @JvmStatic val type: MBTActionType = "CloseAccountSettings"
    }
}

public open class ChangeSignatureAction(private var newSignature: String): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountSettingsFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    open override fun canBePerformed(model: App): Boolean {
        return true
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        AccountSettingsFeature.`get`.forceCast(model).changeSignature(this.newSignature)
        AccountSettingsFeature.`get`.forceCast(application).changeSignature(this.newSignature)
        return history.currentComponent
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun getActionType(): String {
        return ChangeSignatureAction.type
    }

    open override fun tostring(): String {
        return this.getActionType()
    }

    companion object {
        @JvmStatic val type: MBTActionType = "ChangeSignature"
    }
}

public abstract class BaseGroupBySubjectAction protected constructor(private var type: MBTActionType): MBTAction {
    abstract override fun canBePerformed(model: App): Boolean
    abstract override fun events(): YSArray<EventusEvent>
    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return history.currentComponent
    }

    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return AccountSettingsFeature.`get`.includedAll(modelFeatures, applicationFeatures)
    }

    abstract fun performImpl(modelOrApplication: App): Unit
    open override fun getActionType(): MBTComponentType {
        return this.type
    }

    open override fun tostring(): String {
        return this.getActionType()
    }

}

public open class SwitchOnThreadingAction(): BaseGroupBySubjectAction(SwitchOnThreadingAction.type) {
    open override fun canBePerformed(model: App): Boolean {
        val isGroupBySubjectEnabled = AccountSettingsFeature.`get`.forceCast(model).isGroupBySubjectEnabled()
        return !isGroupBySubjectEnabled
    }

    open override fun performImpl(modelOrApplication: App): Unit {
        val modelOrAppImpl = AccountSettingsFeature.`get`.forceCast(modelOrApplication)
        modelOrAppImpl.switchGroupBySubject()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.accountSettingsEvents.toggleThreading(true))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SwitchOnThreading"
    }
}

public open class SwitchOffThreadingAction(): BaseGroupBySubjectAction(SwitchOffThreadingAction.type) {
    open override fun canBePerformed(model: App): Boolean {
        val isGroupBySubjectEnabled = AccountSettingsFeature.`get`.forceCast(model).isGroupBySubjectEnabled()
        return isGroupBySubjectEnabled
    }

    open override fun performImpl(modelOrApplication: App): Unit {
        val modelOrAppImpl = AccountSettingsFeature.`get`.forceCast(modelOrApplication)
        modelOrAppImpl.switchGroupBySubject()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf(Eventus.accountSettingsEvents.toggleThreading(false))
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SwitchOffThreading"
    }
}

public abstract class BaseTabsActions protected constructor(protected var accountType: AccountType): MBTAction {
    open override fun supported(modelFeatures: YSArray<FeatureID>, applicationFeatures: YSArray<FeatureID>): Boolean {
        return (MessageListDisplayFeature.`get`.included(modelFeatures) && TabsFeature.`get`.includedAll(modelFeatures, applicationFeatures))
    }

    open override fun canBePerformed(model: App): Boolean {
        var isAccountTypeYandex = false
        if (this.accountType == AccountType.login) {
            isAccountTypeYandex = true
        }
        val canPerform = this.canBePerformedImpl(model)
        return isAccountTypeYandex && canPerform
    }

    open override fun perform(model: App, application: App, history: MBTHistory): MBTComponent {
        this.performImpl(model)
        this.performImpl(application)
        return history.currentComponent
    }

    abstract override fun events(): YSArray<EventusEvent>
    abstract fun canBePerformedImpl(model: App): Boolean
    abstract fun performImpl(modelOrApplication: App): Unit
    abstract override fun tostring(): String
    abstract override fun getActionType(): MBTActionType
}

public open class SwitchOnTabsAction(accountType: AccountType): BaseTabsActions(accountType) {
    open override fun canBePerformedImpl(model: App): Boolean {
        val isSortingEmailsByCategoryEnabled = AccountSettingsFeature.`get`.forceCast(model).isSortingEmailsByCategoryEnabled()
        return !isSortingEmailsByCategoryEnabled
    }

    open override fun performImpl(modelOrApplication: App): Unit {
        AccountSettingsFeature.`get`.forceCast(modelOrApplication).switchSortingEmailsByCategory()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "SwitchOnTabsAction"
    }

    open override fun getActionType(): String {
        return SwitchOnTabsAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SwitchOnTabsAction"
    }
}

public open class SwitchOffTabsAction(accountType: AccountType): BaseTabsActions(accountType) {
    open override fun canBePerformedImpl(model: App): Boolean {
        val isSortingEmailsByCategoryEnabled = AccountSettingsFeature.`get`.forceCast(model).isSortingEmailsByCategoryEnabled()
        return isSortingEmailsByCategoryEnabled
    }

    open override fun performImpl(modelOrApplication: App): Unit {
        AccountSettingsFeature.`get`.forceCast(modelOrApplication).switchSortingEmailsByCategory()
    }

    open override fun events(): YSArray<EventusEvent> {
        return mutableListOf()
    }

    open override fun tostring(): String {
        return "SwitchOffTabsAction"
    }

    open override fun getActionType(): String {
        return SwitchOffTabsAction.type
    }

    companion object {
        @JvmStatic val type: MBTActionType = "SwitchOffTabsAction"
    }
}

public open class GetThreadingSetting {
    open fun canBePerformed(model: App): Boolean {
        return true
    }

    open fun performImpl(modelOrApplication: App): Unit {
        val modelOrAppImpl = AccountSettingsFeature.`get`.forceCast(modelOrApplication)
        modelOrAppImpl.isGroupBySubjectEnabled()
    }

    open fun tostring(): String {
        return "GetThreadingSetting"
    }

}

