// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/message-list-display-backend.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.filter
import com.yandex.xplat.common.map
import com.yandex.xplat.mapi.Folder
import com.yandex.xplat.mapi.FolderType
import com.yandex.xplat.mapi.MessageMeta
import com.yandex.xplat.mapi.isFolderOfThreadedType
import com.yandex.xplat.testopithecus.common.fail

public open class MessageListDisplayBackend(private var clientsHandler: MailboxClientHandler): MessageListDisplay {
    private var currentFolderId: FolderId? = null
    open fun getCurrentFolderId(): FolderId {
        if (this.currentFolderId == null) {
            this.currentFolderId = MessageListDisplayBackend.getInbox(this.clientsHandler.getCurrentClient()).fid
        }
        return this.currentFolderId!!
    }

    open fun setCurrentFolderId(folderId: FolderId): Unit {
        this.currentFolderId = folderId
    }

    open override fun getMessageList(limit: Int): YSArray<MessageView> {
        return this.getMessageDTOList(limit).map( {
            meta ->
            Message.fromMeta(meta)
        })
    }

    open fun getMessageDTOList(limit: Int): YSArray<MessageMeta> {
        return if (this.isInThreadMode()) this.clientsHandler.getCurrentClient().getThreadsInFolder(this.getCurrentFolderId(), limit) else this.clientsHandler.getCurrentClient().getMessagesInFolder(this.getCurrentFolderId(), limit)
    }

    open override fun unreadCounter(): Int {
        return this.getCurrentFolder().unreadCounter
    }

    open override fun refreshMessageList(): Unit {
        return
    }

    open fun getThreadMessage(byOrder: Int): MessageMeta {
        val threads = this.getMessageDTOList(byOrder + 1)
        val threadsCount = threads.size
        if (threadsCount <= byOrder) {
            fail("No thread in folder ${this.getCurrentFolderId()} by order ${byOrder}, there are ${threadsCount} threads")
        }
        return threads[byOrder]
    }

    open fun getFolder(id: FolderId): Folder {
        return this.clientsHandler.getCurrentClient().getFolderList().filter( {
            f ->
            f.fid == id
        })[0]
    }

    open fun getCurrentFolder(): Folder {
        return this.getFolder(this.getCurrentFolderId())
    }

    open fun getFolderByType(type: FolderType): Folder {
        return MessageListDisplayBackend.getFolderByType(this.clientsHandler.getCurrentClient(), type)
    }

    open fun getInbox(): Folder {
        return this.getFolderByType(FolderType.inbox)
    }

    open fun isInThreadMode(): Boolean {
        val folderType = this.getCurrentFolder().type
        return isFolderOfThreadedType(folderType)
    }

    open override fun goToAccountSwitcher(): Unit {
    }

    companion object {
        @JvmStatic
        private fun getInbox(client: MailboxClient): Folder {
            return MessageListDisplayBackend.getFolderByType(client, FolderType.inbox)
        }

        @JvmStatic
        private fun getFolderByType(client: MailboxClient, type: FolderType): Folder {
            return client.getFolderList().filter( {
                f ->
                f.type == type
            })[0]
        }

    }
}

