// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/mobile-mail-backend.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.App
import com.yandex.xplat.testopithecus.common.FeatureID
import com.yandex.xplat.testopithecus.common.FeatureRegistry

public open class MobileMailBackend(val clientsHandler: MailboxClientHandler): App {
    override var supportedFeatures: YSArray<FeatureID> = MobileMailBackend.allSupportedFeatures
    var archive: ArchiveMessageBackend
    var messageListDisplay: MessageListDisplayBackend
    var folderNavigator: FolderNavigatorBackend
    var markable: MarkableBackend
    var markableImportant: MarkableImportantBackend
    var writeMessage: WriteMessageBackend
    var deleteMessage: DeleteMessageBackend
    var composeMessage: ComposeMessageBackend
    var spamable: SpamableBackend
    var movableToFolder: MovableToFolderBackend
    var creatableFolder: CreatableFolderBackend
    var expandableThreads: ExpandableThreadsBackend
    var loginBackend: LoginBackend
    var multiAccount: MultiAccountBackend
    init {
        this.messageListDisplay = MessageListDisplayBackend(clientsHandler)
        this.folderNavigator = FolderNavigatorBackend(this.messageListDisplay, clientsHandler)
        this.markable = MarkableBackend(this.messageListDisplay, clientsHandler)
        this.markableImportant = MarkableImportantBackend(this.messageListDisplay, clientsHandler)
        this.writeMessage = WriteMessageBackend(this.messageListDisplay, clientsHandler)
        this.deleteMessage = DeleteMessageBackend(this.messageListDisplay, clientsHandler)
        this.composeMessage = ComposeMessageBackend()
        this.spamable = SpamableBackend(this.messageListDisplay, clientsHandler)
        this.movableToFolder = MovableToFolderBackend(this.messageListDisplay, clientsHandler)
        this.creatableFolder = CreatableFolderBackend(clientsHandler)
        this.expandableThreads = ExpandableThreadsBackend(this.messageListDisplay, clientsHandler)
        this.loginBackend = LoginBackend(clientsHandler)
        this.archive = ArchiveMessageBackend(this.messageListDisplay, clientsHandler)
        this.multiAccount = MultiAccountBackend(clientsHandler)
    }
    open override fun getFeature(feature: FeatureID): Any {
        return FeatureRegistry().register(MessageListDisplayFeature.`get`, this.messageListDisplay).register(MarkableReadFeature.`get`, this.markable).register(MarkableImportantFeature.`get`, this.markableImportant).register(ExpandableThreadsFeature.`get`, this.expandableThreads).register(WriteMessageFeature.`get`, this.writeMessage).register(DeleteMessageFeature.`get`, this.deleteMessage).register(ComposeMessageFeature.`get`, this.composeMessage).register(SpamableFeature.`get`, this.spamable).register(FolderNavigatorFeature.`get`, this.folderNavigator).register(MovableToFolderFeature.`get`, this.movableToFolder).register(CreatableFolderFeature.`get`, this.creatableFolder).register(YandexLoginFeature.`get`, this.loginBackend).register(YandexTeamLoginFeature.`get`, this.loginBackend).register(ArchiveMessageFeature.`get`, this.archive).register(MultiAccountFeature.`get`, this.multiAccount).register(MailRuLoginFeature.`get`, this.loginBackend).register(GoogleLoginFeature.`get`, this.loginBackend).register(OutlookLoginFeature.`get`, this.loginBackend).register(HotmailLoginFeature.`get`, this.loginBackend).register(RamblerLoginFeature.`get`, this.loginBackend).register(YahooLoginFeature.`get`, this.loginBackend).register(CustomMailServiceLoginFeature.`get`, this.loginBackend).`get`(feature)
    }

    open override fun dump(model: App): String {
        var s = "${this.messageListDisplay.getCurrentFolder().name}\n"
        val threads = this.messageListDisplay.getMessageDTOList(3)
        for (thread in threads) {
            val threadSelector = if (thread.threadCount != null) "${thread.threadCount!!}v" else ""
            s += "${reduced(thread.mid)} ${thread.sender}\t${if (thread.unread) "*" else "o"}\t${thread.subjectText}\t${threadSelector}\t${thread.timestamp}\n"
            val threadSize = Message.fromMeta(thread).threadCounter
            if (threadSize != null) {
                for (message in this.clientsHandler.getCurrentClient().getMessagesInThread(thread.tid!!, threadSize)) {
                    s += "\t\t${reduced(message.mid)} ${message.sender}\t${if (message.unread) "*" else "o"}\t${message.subjectText}\t${message.fid}\t${thread.timestamp}\n"
                }
            }
        }
        return s
    }

    companion object {
        @JvmStatic var allSupportedFeatures: YSArray<FeatureID> = mutableListOf(ArchiveMessageFeature.`get`.name, MessageListDisplayFeature.`get`.name, MarkableReadFeature.`get`.name, MarkableImportantFeature.`get`.name, ExpandableThreadsFeature.`get`.name, WriteMessageFeature.`get`.name, DeleteMessageFeature.`get`.name, SpamableFeature.`get`.name, MovableToFolderFeature.`get`.name, CreatableFolderFeature.`get`.name, FolderNavigatorFeature.`get`.name, YandexLoginFeature.`get`.name, YandexTeamLoginFeature.`get`.name, MultiAccountFeature.`get`.name, MailRuLoginFeature.`get`.name, GoogleLoginFeature.`get`.name, OutlookLoginFeature.`get`.name, HotmailLoginFeature.`get`.name, RamblerLoginFeature.`get`.name, YahooLoginFeature.`get`.name)
    }
}

