// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/write-message-backend.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.mapi.Email
import com.yandex.xplat.mapi.FolderType
import com.yandex.xplat.mapi.ID
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class WriteMessageBackend(private var messageListDisplayBackend: MessageListDisplayBackend, private var clientsHandler: MailboxClientHandler): WriteMessage {
    open override fun sendMessage(to: String, subject: String): Unit {
        this.sendMessageWithText(to, subject, null)
    }

    open override fun replyMessage(): Unit {
    }

    open override fun openCompose(): Unit {
    }

    open fun getTo(): YSSet<String> {
        return YSSet<String>()
    }

    open fun createThread(to: String, subject: String, size: Int, texts: YSArray<String>?): Unit {
        val targetTexts = if (texts == null) mutableListOf() else texts!!
        if (texts == null) {
            for (i in (0 until size step 1)) {
                targetTexts.add("AUTOCREATED_THREAD_${i}")
            }
        }
        val fid = this.messageListDisplayBackend.getFolderByType(FolderType.sent).fid
        val lastMid = this.getTopMessageMid(fid)
        this.clientsHandler.getCurrentClient().sendMessage(to, subject, targetTexts[0])
        var newMid = lastMid
        while (newMid == lastMid) {
            newMid = this.getTopMessageMid(fid)
        }
        val references = this.clientsHandler.getCurrentClient().getMessageReference(requireNonNull(newMid, "Message should appear!"))
        for (i in (1 until size step 1)) {
            this.clientsHandler.getCurrentClient().sendMessage(to, subject, targetTexts[i], references)
        }
    }

    open override fun sendPrepared(): Unit {
    }

    private fun sendMessageWithText(to: String, subject: String, text: String?): Unit {
        val toEmail = Email.fromString(to)
        var topMidToUpdate: ID? = null
        if (toEmail != null && toEmail.login == this.getCurrentAccountEmail().login) {
            topMidToUpdate = this.getTopMessageMid(this.messageListDisplayBackend.getInbox().fid)
        }
        val textToSend = if (text != null) text!! else "AUTOCREATED_MESSAGE"
        this.clientsHandler.getCurrentClient().sendMessage(to, subject, textToSend)
        if (topMidToUpdate != null) {
            var newMid: MessageId? = topMidToUpdate
            while (newMid == topMidToUpdate) {
                newMid = this.getTopMessageMid(this.messageListDisplayBackend.getInbox().fid)
            }
        }
    }

    private fun getCurrentAccountEmail(): Email {
        return this.clientsHandler.getCurrentClient().getSettings().payload!!.accountInformation.emails[0]
    }

    private fun getTopMessageMid(fid: ID): MessageId? {
        val messages = this.clientsHandler.getCurrentClient().getMessagesInFolder(fid, 1)
        if (messages.size == 0) {
            return null
        }
        return messages[0].mid
    }

}

