// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/account-switcher-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.*

public open class AccountSwitcherComponent: MBTComponent {
    open override fun getComponentType(): MBTComponentType {
        return AccountSwitcherComponent.type
    }

    open override fun assertMatches(model: App, application: App): Unit {
        val multiAccountModel = MultiAccountFeature.`get`.castIfSupported(model)
        val multiAccountApplication = MultiAccountFeature.`get`.castIfSupported(application)
        if (multiAccountModel == null || multiAccountApplication == null) {
            return
        }
        val currAppAcc = multiAccountApplication.getCurrentAccount()
        val currModelAcc = multiAccountModel.getCurrentAccount()
        assertStringEquals(currModelAcc, currAppAcc, "User Email is incorrect")
        val accNumApp = multiAccountApplication.getNumberOfAccounts()
        val accNumModel = multiAccountModel.getNumberOfAccounts()
        assertInt32Equals(accNumModel, accNumApp, "The number of accounts in the Model and in the Application is different")
    }

    open override fun tostring(): String {
        return this.getComponentType()
    }

    companion object {
        @JvmStatic val type: String = "AccountSwitcher"
    }
}

public open class AllAccountSwitcherActions(private var accounts: YSArray<UserAccount>): MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        MultiAccountFeature.`get`.performIfSupported(model, __LBL__AccountSwitcherComponent_1@ {
            _mailboxModel ->
            for (i in (0 until this.accounts.size step 1)) {
                actions.add(SwitchAccountAction(this.accounts[i]))
            }
            actions.add(AddNewAccountAction())
        })
        return actions
    }

}

