// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/compose-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.Log
import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.*

public open class ComposeComponent: MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val composeModel = ComposeMessageFeature.`get`.castIfSupported(model)
        val composeApp = ComposeMessageFeature.`get`.castIfSupported(application)
        if (composeModel != null && composeApp != null) {
            val modelDraft = composeModel.getDraft()
            val appDraft = composeApp.getDraft()
            assertTrue(Draft.matches(modelDraft, appDraft), "Drafts are different")
            Log.info("Drafts are equals ${modelDraft.tostring()} ${appDraft.tostring()}")
        }
    }

    open override fun tostring(): String {
        return this.getComponentType()
    }

    open override fun getComponentType(): MBTComponentType {
        return ComposeComponent.type
    }

    companion object {
        @JvmStatic val type: MBTComponentType = "ComposeComponent"
    }
}

public open class AllComposeActions: MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val composeModel = ComposeMessageFeature.`get`.castIfSupported(model)
        val random = PseudoRandomProvider.INSTANCE
        val fuzzer = Fuzzer()
        val actions: YSArray<MBTAction> = mutableListOf()
        if (composeModel != null) {
            val bodySize: Int = resolveThrow(__LBL__ComposeComponent_1@ {
                 ->
                val draft = composeModel.getDraft()
                val wysiwyg = draft.getWysiwyg()
                return@__LBL__ComposeComponent_1 wysiwyg.getText().length
            }
, 0)
            actions.add(AppendToBody(0, fuzzer.fuzzyBody(random, 1)))
            if (bodySize > 0) {
                actions.add(AppendToBody(random.generate(bodySize), fuzzer.fuzzyBody(random, 1)))
                var randomGenInterval: YSArray<Int> = randomInterval(random, 0, bodySize)
                actions.add(SetItalic(randomGenInterval[0], randomGenInterval[1]))
                randomGenInterval = randomInterval(random, 0, bodySize)
                actions.add(SetStrong(randomGenInterval[0], randomGenInterval[1]))
                randomGenInterval = randomInterval(random, 0, bodySize)
                actions.add(ClearFormatting(randomGenInterval[0], randomGenInterval[1]))
            }
        }
        actions.add(SendMessageAction(fuzzer.fuzzyValidEmail(), fuzzer.naughtyString(1)))
        actions.add(AddToAction(fuzzer.fuzzyValidEmail()))
        actions.add(SetSubjectAction(fuzzer.fuzzyBody(random, 1)))
        actions.add(SendPreparedAction())
        return actions
    }

}

