// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/group-operations-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.testopithecus.common.*

public open class GroupOperationsComponent: MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val groupModeModel = GroupModeFeature.`get`.castIfSupported(model)
        val groupModeApplication = GroupModeFeature.`get`.castIfSupported(application)
        if (groupModeModel == null || groupModeApplication == null) {
            return
        }
        val selectedMessagesOrders = groupModeModel.getSelectedMessages().values()
        for (selectedMessageOrder in selectedMessagesOrders) {
            assertBooleanEquals(true, groupModeApplication.getSelectedMessages().has(selectedMessageOrder), "Message with order ${selectedMessageOrder} is not selected")
        }
        assertBooleanEquals(groupModeModel.isInGroupMode(), groupModeApplication.isInGroupMode(), "Group mode status is incorrect")
        assertInt32Equals(groupModeModel.getNumberOfSelectedMessages(), groupModeApplication.getNumberOfSelectedMessages(), "Number of selected messages is incorrect")
    }

    open override fun tostring(): String {
        return this.getComponentType()
    }

    open override fun getComponentType(): MBTComponentType {
        return GroupOperationsComponent.type
    }

    companion object {
        @JvmStatic val type: MBTComponentType = "GroupOperationsComponent"
    }
}

public open class AllGroupOperationsActions: MBTComponentActions {
    open override fun getActions(_model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        actions.add(MarkAsReadSelectedMessages())
        actions.add(MarkAsUnreadSelectedMessages())
        RotatableAction.addActions(actions)
        return actions
    }

}

public open class NotImplementedInClientsActions: MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        actions.add(DeleteSelectedMessages())
        actions.add(MarkImportantSelectedAction())
        actions.add(MarkUnimportantSelectedAction())
        actions.add(MarkSpamSelectedAction())
        actions.add(MarkNotSpamSelectedAction())
        FolderNavigatorFeature.`get`.performIfSupported(model, __LBL__GroupOperationsComponent_1@ {
            mailboxModel ->
            var folders: YSArray<FolderName>
            try {
                folders = mailboxModel.getFoldersList()
            } catch (e: RuntimeException) {
                folders = mutableListOf()
            }
            for (folder in folders) {
                actions.add(MoveToFolderSelectedMessagesAction(folder))
            }
        })
        val groupMode = GroupModeFeature.`get`.castIfSupported(model)
        if (groupMode != null) {
            val selectedMessages: YSSet<Int> = resolveThrow( {
                 ->
                groupMode.getSelectedMessages()
            }
, YSSet<Int>())
            if (selectedMessages.size > 0) {
                for (i in selectedMessages.values()) {
                    actions.add(UnselectMessageAction(i))
                }
            }
        }
        actions.add(UnselectAllMessagesAction())
        return actions
    }

}

