// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/maillist-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.Log
import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.maxInt32
import com.yandex.xplat.common.minInt32
import com.yandex.xplat.testopithecus.common.*

public open class MaillistComponent(): MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val undoModel = UndoFeature.`get`.castIfSupported(model)
        val undoApplication = UndoFeature.`get`.castIfSupported(application)
        if (undoModel != null && undoApplication != null) {
            val isUndoArchiveToastShownApplication = undoApplication.isUndoArchiveToastShown() == UndoState.shown
            if (isUndoArchiveToastShownApplication) {
                assertBooleanEquals(undoModel.isUndoArchiveToastShown() != UndoState.notShown, isUndoArchiveToastShownApplication, "Undo archive toast state is unexpected")
            } else {
                assertBooleanEquals(undoModel.isUndoArchiveToastShown() == UndoState.shown, isUndoArchiveToastShownApplication, "Undo archive toast state is unexpected")
            }
            val isUndoDeleteToastShownApplication = undoApplication.isUndoDeleteToastShown() == UndoState.shown
            if (isUndoDeleteToastShownApplication) {
                assertBooleanEquals(undoModel.isUndoDeleteToastShown() != UndoState.notShown, isUndoDeleteToastShownApplication, "Undo delete toast state is unexpected")
            } else {
                assertBooleanEquals(undoModel.isUndoDeleteToastShown() == UndoState.shown, isUndoDeleteToastShownApplication, "Undo delete toast state is unexpected")
            }
            val isUndoSpamToastShownApplication = undoApplication.isUndoSpamToastShown() == UndoState.shown
            if (isUndoSpamToastShownApplication) {
                assertBooleanEquals(undoModel.isUndoSpamToastShown() != UndoState.notShown, isUndoSpamToastShownApplication, "Undo spam toast state is unexpected")
            } else {
                assertBooleanEquals(undoModel.isUndoSpamToastShown() == UndoState.shown, isUndoSpamToastShownApplication, "Undo spam toast state is unexpected")
            }
        }
        Log.info("Model and application comparison started")
        val messageListModel = MessageListDisplayFeature.`get`.castIfSupported(model)
        val messageListApplication = MessageListDisplayFeature.`get`.castIfSupported(application)
        if (messageListModel != null && messageListApplication != null) {
            var comparedMessages = 0
            val actualMessages = messageListApplication.getMessageList(10)
            val expectedMessages = messageListModel.getMessageList(10)
            val isCompactModeModel = GeneralSettingsFeature.`get`.forceCast(model).isCompactModeEnabled()
            for (i in (0 until minInt32(maxInt32(actualMessages.size, 1), expectedMessages.size) step 1)) {
                assertTrue(i < actualMessages.size, "There is expected to be message at position ${i} but there was not")
                val actual = actualMessages[i]
                val expected = expectedMessages[i]
                Log.info("№${i}: expected=${expected.tostring()} actual=${actual.tostring()}")
                assertTrue(Message.matches(expected, actual, isCompactModeModel), "Messages are different at position ${i}")
                comparedMessages += 1
            }
            Log.info("Message view is ok, compared: ${comparedMessages}")
            var comparedThreads = 0
            val expandableThreadsModel = ExpandableThreadsModelFeature.`get`.castIfSupported(model)
            val expandableThreadsApplication = ExpandableThreadsModelFeature.`get`.castIfSupported(application)
            if (expandableThreadsModel != null && expandableThreadsApplication != null) {
                val expectedMessagesCount = messageListModel.getMessageList(10).size
                for (threadOrder in (0 until expectedMessagesCount step 1)) {
                    if (expandableThreadsModel.isExpanded(threadOrder)) {
                        comparedThreads += 1
                        val modelMessagesInThread = expandableThreadsModel.getMessagesInThread(threadOrder)
                        val appMessagesInThread = expandableThreadsApplication.getMessagesInThread(threadOrder)
                        for (messageInThreadOrder in (0 until modelMessagesInThread.size step 1)) {
                            val expected = modelMessagesInThread[messageInThreadOrder]
                            val actual = appMessagesInThread[messageInThreadOrder]
                            assertBooleanEquals(expected.read, actual.read, "Messages are different at thread position ${threadOrder}, message position ${messageInThreadOrder}")
                        }
                    }
                }
            }
            val folderNavigatorModel = FolderNavigatorFeature.`get`.castIfSupported(model)
            val folderNavigatorApplication = FolderNavigatorFeature.`get`.castIfSupported(application)
            val tabsModel = TabsFeature.`get`.castIfSupported(model)
            val tabsApplication = TabsFeature.`get`.castIfSupported(application)
            if (folderNavigatorModel != null && folderNavigatorApplication != null && tabsModel != null && tabsApplication != null) {
                if (folderNavigatorModel.isInTabsMode()) {
                    val isDisplayNotificationSubscriptionsTabsModel = tabsModel.isDisplayNotificationTabs(DefaultFolderName.mailingLists)
                    val isDisplayNotificationSocialMediaTabsModel = tabsModel.isDisplayNotificationTabs(DefaultFolderName.socialNetworks)
                    assertBooleanEquals(isDisplayNotificationSubscriptionsTabsModel, tabsApplication.isDisplayNotificationTabs(DefaultFolderName.mailingLists), "Different status notification of ${DefaultFolderName.mailingLists} tab")
                    assertBooleanEquals(isDisplayNotificationSocialMediaTabsModel, tabsApplication.isDisplayNotificationTabs(DefaultFolderName.socialNetworks), "Different status notification of ${DefaultFolderName.socialNetworks} tab")
                    if (isDisplayNotificationSubscriptionsTabsModel) {
                        assertInt32Equals(tabsModel.getPositionTabsNotification(DefaultFolderName.mailingLists), tabsApplication.getPositionTabsNotification(DefaultFolderName.mailingLists), "Different position notification of ${DefaultFolderName.mailingLists} tab in Message list")
                    }
                    if (isDisplayNotificationSocialMediaTabsModel) {
                        assertInt32Equals(tabsModel.getPositionTabsNotification(DefaultFolderName.socialNetworks), tabsApplication.getPositionTabsNotification(DefaultFolderName.socialNetworks), "Different position notification of ${DefaultFolderName.socialNetworks} tab in Message list")
                    }
                }
            }
            Log.info("Model and app are equal, compared ${comparedMessages} messages and ${comparedThreads} expanded threads")
        }
        val groupModeModel = GroupModeFeature.`get`.castIfSupported(model)
        val groupModeApplication = GroupModeFeature.`get`.castIfSupported(application)
        if (groupModeModel != null && groupModeApplication != null) {
            val modelGroupMode = groupModeModel.isInGroupMode()
            val applicationGroupMode = groupModeApplication.isInGroupMode()
            assertBooleanEquals(modelGroupMode, applicationGroupMode, "Group mode state is incorrect")
            Log.info("Groupe mode state is correct, state: ${modelGroupMode}")
        }
    }

    open override fun getComponentType(): String {
        return MaillistComponent.type
    }

    open override fun tostring(): String {
        return "MaillistComponent()"
    }

    companion object {
        @JvmStatic val type: MBTComponentType = "MaillistComponent"
    }
}

public open class AllMaillistActions: MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        MessageListDisplayFeature.`get`.performIfSupported(model, __LBL__MaillistComponent_1@ {
            mailboxModel ->
            val messages: YSArray<MessageView> = resolveThrow( {
                 ->
                mailboxModel.getMessageList(3)
            }
, mutableListOf())
            for (i in (0 until messages.size step 1)) {
                actions.add(MarkAsRead(i))
                actions.add(MarkAsUnread(i))
                actions.add(OpenMessageAction(i))
                actions.add(ExpandThreadAction(i))
                actions.add(CollapseThreadAction(i))
                actions.add(MarkAsReadExpandedAction(i, 0))
                actions.add(MarkAsUnreadExpandedAction(i, 0))
                actions.add(MarkAsImportant(i))
                actions.add(MarkAsUnimportant(i))
                actions.add(MoveToSpamAction(i))
                actions.add(SelectMessage(i))
                actions.add(ArchiveMessageAction(i))
                actions.add(DeleteMessageByShortSwipeAction(i))
                actions.add(ArchiveMessageByShortSwipeAction(i))
                actions.add(DeleteMessageFromContextMenuAction(i))
                actions.add(MarkAsReadFromContextMenuAction(i))
                actions.add(MarkAsUnreadFromContextMenuAction(i))
                actions.add(MarkAsImportantFromContextMenuAction(i))
                actions.add(MarkAsUnImportantFromContextMenuAction(i))
                actions.add(DeleteMessageAction(i))
            }
        })
        StoriesBlockFeature.`get`.performIfSupported(model, __LBL__MaillistComponent_2@ {
            t: StoriesBlock ->
            actions.add(HideStoriesBlockAction())
            val six: Int = 6
            for (i in (0 until six step 1)) {
                actions.add(OpenStoryFromBlockAction(i))
            }
        })
        FolderNavigatorFeature.`get`.performIfSupported(model, __LBL__MaillistComponent_3@ {
            _mailboxModel ->
            val folders = mutableListOf(DefaultFolderName.inbox, DefaultFolderName.sent, DefaultFolderName.trash, DefaultFolderName.spam)
            for (folder in folders) {
                actions.add(GoToFolderAction(folder))
            }
        })
        actions.add(ClearCache())
        RotatableAction.addActions(actions)
        actions.add(OpenComposeAction())
        return actions
    }

}

