// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/settings/account-settings-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.keys
import com.yandex.xplat.common.substr
import com.yandex.xplat.mapi.AccountType
import com.yandex.xplat.mapi.signaturePlaceToInt32
import com.yandex.xplat.testopithecus.common.*

public open class AccountSettingsComponent: MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val accountSettingsModel = AccountSettingsFeature.`get`.castIfSupported(model)
        val accountSettingsApplication = AccountSettingsFeature.`get`.castIfSupported(application)
        val androidAccountSettingsModel = AndroidAccountSettingsFeature.`get`.castIfSupported(model)
        val androidAccountSettingsApplication = AndroidAccountSettingsFeature.`get`.castIfSupported(application)
        val iOSAccountSettingsModel = IosAccountSettingsFeature.`get`.castIfSupported(model)
        val iOSAccountSettingsApplication = IosAccountSettingsFeature.`get`.castIfSupported(application)
        if (accountSettingsModel != null && accountSettingsApplication != null) {
            assertBooleanEquals(accountSettingsModel.isGroupBySubjectEnabled(), accountSettingsApplication.isGroupBySubjectEnabled(), "Group by subject status is incorrect")
            assertBooleanEquals(accountSettingsModel.isThemeEnabled(), accountSettingsApplication.isThemeEnabled(), "FolderList theme status is incorrect")
            assertBooleanEquals(accountSettingsModel.isSortingEmailsByCategoryEnabled(), accountSettingsApplication.isSortingEmailsByCategoryEnabled(), "Tabs status is incorrect")
            assertStringEquals(this.setStandartSignatureIfNeeded(accountSettingsModel.getSignature()), this.setStandartSignatureIfNeeded(accountSettingsApplication.getSignature()), "Signature is incorrect")
            val applicationFolderToNotificationOption = accountSettingsApplication.getFolderToNotificationOption()
            for (folderName in applicationFolderToNotificationOption.keys()) {
                assertStringEquals(applicationFolderToNotificationOption.`get`(folderName)!!.toString(), accountSettingsModel.getNotificationOptionForFolder(folderName).toString(), "Notification option for folder ${folderName} is incorrect")
            }
        }
        if (iOSAccountSettingsModel != null && iOSAccountSettingsApplication != null) {
            assertStringEquals(iOSAccountSettingsModel.getPushNotificationSound().toString(), iOSAccountSettingsApplication.getPushNotificationSound().toString(), "Notification sound is incorrect")
            assertBooleanEquals(iOSAccountSettingsModel.isPushNotificationForAllEnabled(), iOSAccountSettingsApplication.isPushNotificationForAllEnabled(), "Push notification for all status is incorrect")
        }
        if (androidAccountSettingsModel != null && androidAccountSettingsApplication != null) {
            assertBooleanEquals(androidAccountSettingsModel.isAccountUsingEnabled(), androidAccountSettingsApplication.isAccountUsingEnabled(), "Account using status is incorrect")
            assertInt32Equals(signaturePlaceToInt32(androidAccountSettingsModel.getPlaceForSignature()), signaturePlaceToInt32(androidAccountSettingsApplication.getPlaceForSignature()), "Place for signature is incorrect")
        }
    }

    private fun setStandartSignatureIfNeeded(signature: String): String {
        return if (signature == "") "Sent from Yandex.Mail for mobile" else signature.substr(-32)
    }

    open override fun getComponentType(): String {
        return AccountSettingsComponent.type
    }

    open override fun tostring(): String {
        return this.getComponentType()
    }

    companion object {
        @JvmStatic val type: String = "AccountSettings"
    }
}

public open class AllAccountSettingsActions(val accountType: AccountType): MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        MultiAccountFeature.`get`.performIfSupported(model, __LBL__AccountSettingsComponent_1@ {
            mailboxModel ->
            actions.add(CloseAccountSettingsAction())
            actions.add(SwitchOnThreadingAction())
            actions.add(SwitchOffThreadingAction())
            actions.add(SwitchOnTabsAction(this.accountType))
            actions.add(SwitchOffTabsAction(this.accountType))
        })
        return actions
    }

}

