// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/settings/general-settings-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.*

public open class GeneralSettingsComponent: MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val generalSettingsModel = GeneralSettingsFeature.`get`.castIfSupported(model)
        val generalSettingsApplication = GeneralSettingsFeature.`get`.castIfSupported(application)
        val androidGeneralSettingsModel = AndroidGeneralSettingsFeature.`get`.castIfSupported(model)
        val androidGeneralSettingsApplication = AndroidGeneralSettingsFeature.`get`.castIfSupported(application)
        val iOSGeneralSettingsModel = IosGeneralSettingsFeature.`get`.castIfSupported(model)
        val iOSGeneralSettingsApplication = IosGeneralSettingsFeature.`get`.castIfSupported(application)
        val pinModel = PinFeature.`get`.castIfSupported(model)
        val pinApplication = PinFeature.`get`.castIfSupported(application)
        if (generalSettingsModel != null && generalSettingsApplication != null) {
            assertStringEquals(generalSettingsModel.getActionOnSwipe().toString(), generalSettingsApplication.getActionOnSwipe().toString(), "Action on swipe is incorrect")
            if (pinModel != null && pinApplication != null) {
                assertBooleanEquals(generalSettingsModel.isLoginUsingPasswordEnabled(), generalSettingsApplication.isLoginUsingPasswordEnabled(), "Pin status is incorrect")
            }
            assertBooleanEquals(generalSettingsModel.isCompactModeEnabled(), generalSettingsApplication.isCompactModeEnabled(), "Compact mode status is incorrect")
            assertBooleanEquals(generalSettingsModel.isDarkThemeEnabled(), generalSettingsApplication.isDarkThemeEnabled(), "Dark theme status is incorrect")
            assertBooleanEquals(generalSettingsModel.isVoiceControlEnabled(), generalSettingsApplication.isVoiceControlEnabled(), "Voice control status is incorrect")
            assertStringEquals(generalSettingsModel.getVoiceControlLanguage().toString(), generalSettingsApplication.getVoiceControlLanguage().toString(), "Voice control language is incorrect")
            assertBooleanEquals(generalSettingsModel.isTranslatorEnabled(), generalSettingsApplication.isTranslatorEnabled(), "Translator status is incorrect")
            assertStringEquals(generalSettingsModel.getDefaultTranslationLanguage(), generalSettingsApplication.getDefaultTranslationLanguage(), "Translation default language is incorrect")
            assertBooleanEquals(generalSettingsModel.isAdsEnabled(), generalSettingsApplication.isAdsEnabled(), "Ads status is incorrect")
            assertStringEquals(generalSettingsModel.getCancelSendingEmail().toString(), generalSettingsModel.getCancelSendingEmail().toString(), "Cancel sending email option is incorrect")
        }
        if (androidGeneralSettingsModel != null && androidGeneralSettingsApplication != null) {
            assertBooleanEquals(androidGeneralSettingsModel.isDoNotDisturbModeEnabled(), androidGeneralSettingsApplication.isDoNotDisturbModeEnabled(), "Do not disturb mode status is incorrect")
        }
        if (iOSGeneralSettingsModel != null && iOSGeneralSettingsApplication != null) {
            assertBooleanEquals(iOSGeneralSettingsModel.isIconBadgeForActiveAccountEnabled(), iOSGeneralSettingsApplication.isIconBadgeForActiveAccountEnabled(), "Icon badge for active account state is incorrect")
            assertBooleanEquals(iOSGeneralSettingsModel.isSystemThemeSyncEnabled(), iOSGeneralSettingsApplication.isSystemThemeSyncEnabled(), "System theme sync status is incorrect")
            assertStringEquals(iOSGeneralSettingsModel.getSelectedBrowser().toString(), iOSGeneralSettingsApplication.getSelectedBrowser().toString(), "Selected browser is incorrect")
            val apllicationIgnoredLanguages = generalSettingsApplication!!.getIgnoredTranslationLanguages()
            val modelIgnoredLanguages = generalSettingsModel!!.getIgnoredTranslationLanguages()
            for (i in (0 until apllicationIgnoredLanguages.size step 1)) {
                assertStringEquals(modelIgnoredLanguages[i], apllicationIgnoredLanguages[i], "Ignored translation language list is incorrect")
            }
            assertBooleanEquals(generalSettingsModel!!.isSmartRepliesEnabled(), generalSettingsApplication!!.isSmartRepliesEnabled(), "Smart replies status is incorrect")
        }
    }

    open override fun tostring(): String {
        return "GeneralSettingsComponent()"
    }

    open override fun getComponentType(): String {
        return GeneralSettingsComponent.type
    }

    companion object {
        @JvmStatic val type: String = "GeneralSettingsComponent"
    }
}

public open class AllGeneralSettingsActions: MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        actions.add(CloseAboutSettingsAction())
        actions.add(ClearCache())
        return actions
    }

}

