// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/settings/root-settings-component.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.testopithecus.common.*

public open class RootSettingsComponent: MBTComponent {
    open override fun assertMatches(model: App, application: App): Unit {
        val rootSettingsModel = RootSettingsFeature.`get`.castIfSupported(model)
        val rootSettingsApplication = RootSettingsFeature.`get`.castIfSupported(application)
        val iOSRootSettingsModel = IOSRootSettingsFeature.`get`.castIfSupported(model)
        val iOSRootSettingsApplication = IOSRootSettingsFeature.`get`.castIfSupported(application)
        if (iOSRootSettingsModel != null && iOSRootSettingsApplication != null) {
            val generalSettingCellModel = iOSRootSettingsModel.isGeneralSettingsCellExists()
            val generalSettingCellApp = iOSRootSettingsApplication.isGeneralSettingsCellExists()
            assertBooleanEquals(generalSettingCellModel, generalSettingCellApp, "There is no General settings cell")
        }
        val androidRootSettingsModel = AndroidRootSettingsFeature.`get`.castIfSupported(model)
        val androidRootSettingsApplication = AndroidRootSettingsFeature.`get`.castIfSupported(application)
        if (androidRootSettingsModel != null && androidRootSettingsApplication != null) {
            val addAccCellModel = androidRootSettingsModel.isAddAccountCellExists()
            val addAccCellApp = androidRootSettingsApplication.isAddAccountCellExists()
            assertBooleanEquals(addAccCellModel, addAccCellApp, "There is no Add account cell")
        }
        if (rootSettingsModel != null && rootSettingsApplication != null) {
            val titleModel = rootSettingsModel.getTitle()
            val titleApp = rootSettingsApplication.getTitle()
            assertStringEquals(titleModel, titleApp, "Incorrect root settings title")
            val accountsModel = rootSettingsModel.getAccounts()
            val accountsApplication = rootSettingsApplication.getAccounts()
            assertInt32Equals(accountsModel.size, accountsApplication.size, "There is different number of accounts")
            for (accountModel in accountsModel) {
                assertTrue(accountsApplication.contains(accountModel), "There is no account with name ${accountModel}")
            }
            val aboutCellModel = rootSettingsModel.isAboutCellExists()
            val aboutCellApp = rootSettingsApplication.isAboutCellExists()
            assertBooleanEquals(aboutCellModel, aboutCellApp, "There is no About cell")
            val helpAndFeedbackCellModel = rootSettingsModel.isHelpAndFeedbackCellExists()
            val helpAndFeedbackCellApp = rootSettingsApplication.isHelpAndFeedbackCellExists()
            assertBooleanEquals(helpAndFeedbackCellModel, helpAndFeedbackCellApp, "There is no Help and feedback cell")
        }
    }

    open override fun tostring(): String {
        return "RootSettingsComponent()"
    }

    open override fun getComponentType(): String {
        return RootSettingsComponent.type
    }

    companion object {
        @JvmStatic val type: String = "RootSettingsComponent"
    }
}

public open class AllRootSettingsActions: MBTComponentActions {
    open override fun getActions(model: App): YSArray<MBTAction> {
        val actions: YSArray<MBTAction> = mutableListOf()
        actions.add(CloseRootSettings())
        actions.add(OpenGeneralSettingsAction())
        actions.add(OpenSettingsAction())
        actions.add(OpenAboutSettingsAction())
        return actions
    }

}

