// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/folder-data-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.int64
import com.yandex.xplat.mapi.ID

public open class DefaultFolderName {
    companion object {
        @JvmStatic var inbox: FolderName = "Inbox"
        @JvmStatic var mailingLists: FolderName = "Mailing lists"
        @JvmStatic var socialNetworks: FolderName = "Social networks"
        @JvmStatic var sent: FolderName = "Sent"
        @JvmStatic var outgoing: FolderName = "Outbox"
        @JvmStatic var trash: FolderName = "Trash"
        @JvmStatic var spam: FolderName = "Spam"
        @JvmStatic var draft: FolderName = "Drafts"
        @JvmStatic var template: FolderName = "Templates"
        @JvmStatic var archive: FolderName = "Archive"
    }
}

public open class TabBackendName {
    companion object {
        @JvmStatic var inbox: FolderName = "relevant"
        @JvmStatic var mailingLists: FolderName = "news"
        @JvmStatic var socialNetworks: FolderName = "social"
    }
}

public fun formatTabNameIfNeeded(folderName: FolderName): FolderName {
    when (folderName) {
        TabBackendName.inbox -> {
            return DefaultFolderName.inbox
        }
        TabBackendName.socialNetworks -> {
            return DefaultFolderName.socialNetworks
        }
        TabBackendName.mailingLists -> {
            return DefaultFolderName.mailingLists
        }
        else -> {
            return folderName
        }
    }
}

public fun isTab(name: FolderName): Boolean {
    return mutableListOf(TabBackendName.socialNetworks, TabBackendName.mailingLists, TabBackendName.inbox).contains(name)
}

public fun tabNameToFid(tabName: FolderName): ID {
    when (tabName) {
        TabBackendName.inbox -> {
            return int64(-10)
        }
        TabBackendName.mailingLists -> {
            return int64(-11)
        }
        TabBackendName.socialNetworks -> {
            return int64(-12)
        }
        else -> {
            throw Error("This is no tab")
        }
    }
}

public fun toBackendFolderName(folderDisplayName: String, parentFolders: YSArray<String>): String {
    when (folderDisplayName) {
        DefaultFolderName.inbox -> {
            return "Inbox"
        }
        DefaultFolderName.sent -> {
            return "Sent"
        }
        DefaultFolderName.outgoing -> {
            return "Outbox"
        }
        DefaultFolderName.trash -> {
            return "Trash"
        }
        DefaultFolderName.spam -> {
            return "Spam"
        }
        DefaultFolderName.draft -> {
            return "Drafts"
        }
        DefaultFolderName.archive -> {
            return "Archive"
        }
        else -> {
            return formatFolderName(folderDisplayName, parentFolders)
        }
    }
}

