// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/mail-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.mapi.Attachment
import com.yandex.xplat.mapi.ID
import com.yandex.xplat.mapi.MessageMeta
import com.yandex.xplat.mapi.SignaturePlace
import com.yandex.xplat.testopithecus.common.*

public open class ScreenTitle {
    companion object {
        @JvmStatic val rootSettings: String = "Settings"
        @JvmStatic val helpAndFeedback: String = "Help and feedback"
        @JvmStatic
        open fun folder(folder: FolderName, unreadCounter: Int): String {
            return "${folder} ${unreadCounter}"
        }

    }
}

public open class Message(override var from: String, override var subject: String, override var timestamp: Long, override var firstLine: String, override var threadCounter: Int? = null, override var read: Boolean = false, override var important: Boolean = false, override var attachments: YSArray<AttachmentView> = mutableListOf()): MessageView {
    override var to: String = "(No recipients)"
    open fun threadSize(): Int {
        val counter = this.threadCounter
        return if (counter != null) counter else 1
    }

    open override fun tostring(): String {
        return "MessageView(from=${this.from}, subject=${this.subject}, read=${this.read}, important=${this.important}, threadCounter=${this.threadCounter}, firstLine=${this.firstLine})"
    }

    open fun copy(): Message {
        return Message(this.from, this.subject, this.timestamp, this.firstLine, this.threadCounter, this.read, this.important, this.attachments)
    }

    companion object {
        @JvmStatic
        open fun fromMeta(meta: MessageMeta): Message {
            return Message(meta.sender, meta.subjectText, meta.timestamp, meta.firstLine, if (meta.threadCount == null) null else stringToInt32(meta.threadCount!!), !meta.unread, false, if (meta.attachments == null) mutableListOf() else meta.attachments!!.attachments.map( {
                item ->
                MessageAttach.fromMetaAttach(item)
            }))
        }

        @JvmStatic
        open fun matches(first: MessageView, second: MessageView, isCompantMode: Boolean = false): Boolean {
            var matchAttachments = true
            var matchFrom: Boolean
            val matchImportant: Boolean = if (isCompantMode) true else first.important == second.important
            if (first.from.length == second.from.length) {
                matchFrom = first.from == second.from
            } else {
                matchFrom = first.from.substr(1, second.from.length) == second.from
            }
            for (item in (0 until minInt32(maxInt32(second.attachments.size, 1), first.attachments.size) step 1)) {
                val secondView = second.attachments[item]
                val firstView = first.attachments[item]
                if (secondView.displayName != firstView.displayName) {
                    matchAttachments = false
                }
            }
            return (first.subject == second.subject && first.read == second.read && first.attachments.size == second.attachments.size && first.threadCounter == second.threadCounter && first.firstLine.substr(0, 10) == second.firstLine.substr(0, 10) && matchImportant && matchFrom && matchAttachments)
        }

    }
}

public open class MessageAttach(override val displayName: String): AttachmentView {
    companion object {
        @JvmStatic
        open fun fromMetaAttach(item: Attachment): AttachmentView {
            return MessageAttach(item.displayName)
        }

    }
}

public open class FullMessage(head: Message, override var to: YSSet<String> = YSSet<String>(), override var body: String = ""): FullMessageView {
    override val head: MessageView
    var mutableHead: Message
    init {
        this.head = head
        this.mutableHead = head
    }
    open override fun tostring(): String {
        return ("Message(from=${this.head.from},subject=${this.head.subject}, read=${this.head.read}, to=${this.to}," + "body=${this.body})")
    }

    open fun copy(): FullMessage {
        return FullMessage(this.mutableHead.copy(), this.to, this.body)
    }

    companion object {
        @JvmStatic
        open fun fromMeta(meta: MessageMeta): FullMessage {
            return FullMessage(Message.fromMeta(meta))
        }

        @JvmStatic
        open fun matches(first: FullMessageView, second: FullMessageView): Boolean {
            return Message.matches(first.head, second.head) && first.to == second.to && first.body == second.body
        }

    }
}

public typealias MessageId = ID

public typealias FolderId = ID

public open class MailAppModelHandler(var accountsData: YSArray<AccountMailboxData>) {
    var accountsManager: AccountsManager
    init {
        this.accountsManager = AccountsManager(accountsData.map( {
            data ->
            data.userAccount
        }))
    }
    open fun choseAccountFromAccountsManager(account: UserAccount): Unit {
        this.accountsManager.logInToAccount(account)
    }

    open fun logInToAccount(account: UserAccount): Unit {
        this.accountsManager.logInToAccount(account)
    }

    open fun revokeToken(account: UserAccount): Unit {
        this.accountsManager.revokeToken(account)
    }

    open fun switchToAccountByOrder(loginOrder: Int): Unit {
        this.accountsManager.switchToAccountByOrder(loginOrder)
    }

    open fun switchToAccountByLogin(login: Login): Unit {
        this.accountsManager.switchToAccount(login)
    }

    open fun isLoggedIn(): Boolean {
        return this.accountsManager.isLoggedIn()
    }

    open fun getCurrentAccount(): AccountMailboxData {
        if (!this.hasCurrentAccount()) {
            fail("Account was requested, but is not set")
        }
        return this.accountsData[this.accountsManager.currentAccount!!]
    }

    open fun getLoggedInAccounts(): YSArray<UserAccount> {
        return this.accountsManager.getLoggedInAccounts()
    }

    open fun hasCurrentAccount(): Boolean {
        return (this.accountsManager.currentAccount != null && this.accountsManager.currentAccount!! < this.accountsData.size)
    }

    open fun logoutAccount(login: Login): Unit {
        this.accountsManager.logoutAccount(login)
    }

    open fun copy(): MailAppModelHandler {
        val accountsDataCopy = this.accountsData.map( {
            acc ->
            acc.copy()
        })
        val result = MailAppModelHandler(accountsDataCopy)
        result.accountsManager = this.accountsManager.copy()
        return result
    }

}

public open class AccountSettingsModel(var groupBySubjectEnabled: Boolean, var sortingEmailsByCategoryEnabled: Boolean, var signature: String, var placeForSignature: SignaturePlace, var folderList: YSArray<FolderName>) {
    var folderToNotificationOption: YSMap<FolderName, NotificationOption>
    var notificationSound: NotificationSound = NotificationSound.yandexMail
    var phoneNumber: String = ""
    var accountUsingEnabled: Boolean = true
    var pushNotificationForAllEnabled: Boolean = true
    var themeEnabled: Boolean = true
    private var ignoredFolders: YSArray<FolderName> = mutableListOf(DefaultFolderName.sent, DefaultFolderName.trash, DefaultFolderName.spam, DefaultFolderName.draft, DefaultFolderName.template, DefaultFolderName.archive, DefaultFolderName.outgoing)
    init {
        this.folderToNotificationOption = mutableMapOf<FolderName, NotificationOption>()
        folderList.filter( {
            folderName ->
            !this.ignoredFolders.contains(folderName)
        }).forEach(__LBL__MailModel_1@ {
            folderName ->
            this.folderToNotificationOption.set(folderName as FolderName, NotificationOption.syncAndNotifyMe)
        })
    }
}

public open class AccountMailboxData(val userAccount: UserAccount, var messagesDB: MessageListDatabase, var aliases: YSArray<String>, var contacts: YSArray<String>, var accountSettings: AccountSettingsModel, var zeroSuggest: YSArray<String>) {
    open fun copy(): AccountMailboxData {
        val userAccountCopy = UserAccount(this.userAccount.login, this.userAccount.password)
        val accountSettingsCopy = AccountSettingsModel(this.accountSettings.groupBySubjectEnabled, this.accountSettings.sortingEmailsByCategoryEnabled, this.accountSettings.signature, this.accountSettings.placeForSignature, this.accountSettings.folderList)
        val aliasesCopy = copyArray(this.aliases)
        val contactsCopy = copyArray(this.contacts)
        val messagesDBCopy = this.messagesDB.copy()
        val zeroSuggestCopy = copyArray(this.zeroSuggest)
        return AccountMailboxData(userAccountCopy, messagesDBCopy, aliasesCopy, contactsCopy, accountSettingsCopy, zeroSuggestCopy)
    }

}

public open class MailboxModel(val mailAppModelHandler: MailAppModelHandler): AppModel {
    override var supportedFeatures: YSArray<FeatureID> = copyArray(MailboxModel.allSupportedFeatures)
    val containerGetter: ContainerGetterModel
    val messageListDisplay: MessageListDisplayModel
    val markableRead: MarkableReadModel
    val markableImportant: MarkableImportantModel
    val messageNavigator: OpenMessageModel
    val deletableMessages: DeleteMessageModel
    val groupMode: GroupModeModel
    val rotatable: RotatableModel
    val readOnlyExpandableThreads: ReadOnlyExpandableThreadsModel
    val expandableThreads: ExpandableThreadsModel
    val writable: WriteMessageModel
    val composable: ComposeMessageModel
    val folderNavigator: FolderNavigatorModel
    val movableToFolder: MovableToFolderModel
    val creatableFolder: CreatableFolderModel
    val wysiwyg: WysiwygModel
    val login: LoginModel
    val multiAccount: MultiAccountModel
    val contextMenu: ContextMenuModel
    val shortSwipe: ShortSwipeModel
    val longSwipe: LongSwipeModel
    val archiveMessage: ArchiveMessageModel
    val accountSettingsModel: AccountSettingModel
    val generalSettingsModel: GeneralSettingsModel
    val rootSettingsModel: RootSettingsModel
    val aboutSettingsModel: AboutSettingsModel
    val spammable: SpamableModel
    val search: SearchModel
    val advancedSearch: AdvancedSearchModel
    val zeroSuggest: ZeroSuggestModel
    val createLabel: LabelModel
    val manageLabels: ManageLabelsModel
    val manageFolders: ManageFoldersModel
    val labelNavigator: LabelNavigatorModel
    val filterNavigator: FilterNavigatorModel
    val storiesBlockModel: StoriesBlockModel
    val undo: UndoModel
    val pin: PinModel
    val applicationState: ApplicationRunningStateModel
    val tabs: TabsModel
    val accountManager: AccountManagerModel
    val expiredToken: ExpiringTokenModel
    init {
        val accountsSettings: YSArray<AccountSettingsModel> = mailAppModelHandler.accountsData.map(__LBL__MailModel_2@ {
            account ->
            return@__LBL__MailModel_2 account.accountSettings
        })
        this.messageListDisplay = MessageListDisplayModel(this.mailAppModelHandler)
        this.pin = PinModel()
        this.accountSettingsModel = AccountSettingModel(accountsSettings, this.mailAppModelHandler.accountsManager, this.mailAppModelHandler)
        this.generalSettingsModel = GeneralSettingsModel(this.pin)
        this.aboutSettingsModel = AboutSettingsModel()
        this.rootSettingsModel = RootSettingsModel(this.messageListDisplay, this.mailAppModelHandler.accountsManager)
        this.search = SearchModel(this.messageListDisplay)
        this.advancedSearch = AdvancedSearchModel(this.messageListDisplay)
        this.zeroSuggest = ZeroSuggestModel(this.mailAppModelHandler, this.search, this.messageListDisplay)
        this.markableRead = MarkableReadModel(this.messageListDisplay, this.mailAppModelHandler)
        this.spammable = SpamableModel(this.messageListDisplay, this.mailAppModelHandler)
        this.storiesBlockModel = StoriesBlockModel()
        this.containerGetter = ContainerGetterModel(this.messageListDisplay)
        this.createLabel = LabelModel(this.mailAppModelHandler)
        this.manageLabels = ManageLabelsModel(this.mailAppModelHandler)
        this.manageFolders = ManageFoldersModel(this.mailAppModelHandler)
        this.labelNavigator = LabelNavigatorModel(this.messageListDisplay, this.mailAppModelHandler)
        this.filterNavigator = FilterNavigatorModel(this.messageListDisplay)
        this.archiveMessage = ArchiveMessageModel(this.messageListDisplay, this.mailAppModelHandler)
        this.deletableMessages = DeleteMessageModel(this.messageListDisplay, this.mailAppModelHandler)
        this.undo = UndoModel(this.deletableMessages, this.archiveMessage, this.spammable, this.mailAppModelHandler, this.messageListDisplay)
        this.folderNavigator = FolderNavigatorModel(this.messageListDisplay, this.mailAppModelHandler, this.undo)
        this.markableImportant = MarkableImportantModel(this.messageListDisplay, this.mailAppModelHandler)
        this.rotatable = RotatableModel()
        this.applicationState = ApplicationRunningStateModel()
        this.readOnlyExpandableThreads = ReadOnlyExpandableThreadsModel(this.messageListDisplay, this.mailAppModelHandler)
        this.expandableThreads = ExpandableThreadsModel(this.readOnlyExpandableThreads, this.messageListDisplay)
        this.messageNavigator = OpenMessageModel(this.markableRead, this.markableImportant, this.expandableThreads, this.messageListDisplay, this.createLabel, this.deletableMessages, this.mailAppModelHandler)
        this.wysiwyg = WysiwygModel()
        this.composable = ComposeMessageModel(this.wysiwyg, this.mailAppModelHandler)
        this.writable = WriteMessageModel(this.mailAppModelHandler, this.messageNavigator, this.composable, mailAppModelHandler, this.wysiwyg)
        this.movableToFolder = MovableToFolderModel(this.messageListDisplay, this.mailAppModelHandler)
        this.creatableFolder = CreatableFolderModel(this.mailAppModelHandler)
        this.contextMenu = ContextMenuModel(this.deletableMessages, this.markableImportant, this.markableRead, this.movableToFolder, this.messageListDisplay, this.createLabel, this.spammable, this.composable, this.archiveMessage)
        this.shortSwipe = ShortSwipeModel(this.deletableMessages, this.archiveMessage, this.markableRead)
        this.longSwipe = LongSwipeModel(this.deletableMessages, this.archiveMessage)
        this.login = LoginModel(mailAppModelHandler, this.messageListDisplay)
        this.multiAccount = MultiAccountModel(mailAppModelHandler)
        this.accountManager = AccountManagerModel(mailAppModelHandler)
        this.expiredToken = ExpiringTokenModel(mailAppModelHandler)
        this.groupMode = GroupModeModel(this.markableRead, this.deletableMessages, this.archiveMessage, this.markableImportant, this.spammable, this.movableToFolder, this.messageListDisplay, this.createLabel)
        this.tabs = TabsModel(this.messageListDisplay, this.mailAppModelHandler)
        val storiesBlockViewCounter = StoriesBlockViewCounter(this.storiesBlockModel, this.messageListDisplay)
        this.messageListDisplay.attach(storiesBlockViewCounter)
        this.rotatable.attach(storiesBlockViewCounter)
    }
    open override fun getFeature(feature: FeatureID): Any {
        return FeatureRegistry().register(MessageListDisplayFeature.`get`, this.messageListDisplay).register(FolderNavigatorFeature.`get`, this.folderNavigator).register(MessageViewerFeature.`get`, this.messageNavigator).register(ThreadViewNavigatorFeature.`get`, this.messageNavigator).register(MarkableReadFeature.`get`, this.markableRead).register(MarkableImportantFeature.`get`, this.markableImportant).register(GroupModeFeature.`get`, this.groupMode).register(RotatableFeature.`get`, this.rotatable).register(ExpandableThreadsModelFeature.`get`, this.readOnlyExpandableThreads).register(ExpandableThreadsFeature.`get`, this.expandableThreads).register(WriteMessageFeature.`get`, this.writable).register(DeleteMessageFeature.`get`, this.deletableMessages).register(ComposeMessageFeature.`get`, this.composable).register(SpamableFeature.`get`, this.spammable).register(MovableToFolderFeature.`get`, this.movableToFolder).register(CreatableFolderFeature.`get`, this.creatableFolder).register(WysiwygFeature.`get`, this.wysiwyg).register(YandexLoginFeature.`get`, this.login).register(YandexTeamLoginFeature.`get`, this.login).register(ContextMenuFeature.`get`, this.contextMenu).register(ShortSwipeFeature.`get`, this.shortSwipe).register(LongSwipeFeature.`get`, this.longSwipe).register(ArchiveMessageFeature.`get`, this.archiveMessage).register(UndoFeature.`get`, this.undo).register(MultiAccountFeature.`get`, this.multiAccount).register(SearchFeature.`get`, this.search).register(ZeroSuggestFeature.`get`, this.zeroSuggest).register(CreatableLabelFeature.`get`, this.createLabel).register(LabelNavigatorFeature.`get`, this.labelNavigator).register(FilterNavigatorFeature.`get`, this.filterNavigator).register(ContainerGetterFeature.`get`, this.containerGetter).register(AccountSettingsFeature.`get`, this.accountSettingsModel).register(IosAccountSettingsFeature.`get`, this.accountSettingsModel).register(AndroidAccountSettingsFeature.`get`, this.accountSettingsModel).register(AboutSettingsFeature.`get`, this.aboutSettingsModel).register(GeneralSettingsFeature.`get`, this.generalSettingsModel).register(IosGeneralSettingsFeature.`get`, this.generalSettingsModel).register(AndroidGeneralSettingsFeature.`get`, this.generalSettingsModel).register(RootSettingsFeature.`get`, this.rootSettingsModel).register(IOSRootSettingsFeature.`get`, this.rootSettingsModel).register(AndroidRootSettingsFeature.`get`, this.rootSettingsModel).register(StoriesBlockFeature.`get`, this.storiesBlockModel).register(MailRuLoginFeature.`get`, this.login).register(GoogleLoginFeature.`get`, this.login).register(OutlookLoginFeature.`get`, this.login).register(HotmailLoginFeature.`get`, this.login).register(RamblerLoginFeature.`get`, this.login).register(YahooLoginFeature.`get`, this.login).register(CustomMailServiceLoginFeature.`get`, this.login).register(PinFeature.`get`, this.pin).register(ApplicationRunningStateFeature.`get`, this.applicationState).register(ManageableFolderFeature.`get`, this.manageFolders).register(ManageableLabelFeature.`get`, this.manageLabels).register(TabsFeature.`get`, this.tabs).register(AccountsListFeature.`get`, this.accountManager).register(ExpiringTokenFeature.`get`, this.expiredToken).`get`(feature)
    }

    open override fun copy(): AppModel {
        val accountDataHandlerCopy = this.mailAppModelHandler.copy()
        val model: MailboxModel = MailboxModel(accountDataHandlerCopy)
        model.supportedFeatures = this.supportedFeatures
        model.messageNavigator.openedMessage = this.messageNavigator.openedMessage
        model.rotatable.landscape = this.rotatable.landscape
        if (this.groupMode.selectedOrders != null) {
            model.groupMode.selectedOrders = copySet(this.groupMode.selectedOrders)
        }
        for (id in this.readOnlyExpandableThreads.expanded.values()) {
            model.readOnlyExpandableThreads.expanded.add(id)
        }
        if (this.composable.composeDraft != null) {
            model.composable.composeDraft = this.composable.composeDraft!!.copy()
        }
        return model
    }

    open override fun getCurrentStateHash(): Long {
        return MailboxModelHasher().getMailboxModelHash(this)
    }

    open override fun dump(model: App): String {
        var s = ""
        if (!this.messageListDisplay.accountDataHandler.hasCurrentAccount()) {
            return "There is no logged in account"
        }
        val threadMids = this.messageListDisplay.getMessageIdList(10)
        s += "${this.messageListDisplay.getCurrentContainer().name}\n"
        for (i in (0 until threadMids.size step 1)) {
            val threadMid = threadMids[i]
            if (this.messageListDisplay.isInThreadMode()) {
                val thread = this.mailAppModelHandler.getCurrentAccount().messagesDB.makeMessageThreadView(threadMid)
                val msgHead = thread.mutableHead
                val threadSelector = if (msgHead.threadCounter != null) "${msgHead.threadCounter!!}v" else ""
                s += "${reduced(threadMid)} ${msgHead.from}\t${if (msgHead.read) "o" else "*"}" + "\t${msgHead.subject}\t${threadSelector}\t${msgHead.timestamp}\n"
                if (msgHead.threadCounter != null) {
                    for (mid in this.mailAppModelHandler.getCurrentAccount().messagesDB.getMessagesInThreadByMid(threadMid)) {
                        s += this.dumpMessage(mid)
                    }
                }
            } else {
                s += this.dumpMessage(threadMid)
            }
        }
        return s
    }

    private fun dumpMessage(mid: MessageId): String {
        val messagesDB = this.mailAppModelHandler.getCurrentAccount().messagesDB
        val message = messagesDB.storedMessage(mid)
        return ("\t\t${reduced(mid)} ${message.head.from}\t${if (message.head.read) "o" else "*"}\t${message.head.subject}" + "\t${messagesDB.storedFolder(mid)}\t${message.mutableHead.timestamp}" + "\t${setToArray(messagesDB.getMessageLabels(mid)).join(",")}\n")
    }

    companion object {
        @JvmStatic var allSupportedFeatures: YSArray<FeatureID> = mutableListOf(MessageListDisplayFeature.`get`.name, FolderNavigatorFeature.`get`.name, MessageViewerFeature.`get`.name, ThreadViewNavigatorFeature.`get`.name, MarkableReadFeature.`get`.name, MarkableImportantFeature.`get`.name, GroupModeFeature.`get`.name, RotatableFeature.`get`.name, ExpandableThreadsModelFeature.`get`.name, ExpandableThreadsFeature.`get`.name, WriteMessageFeature.`get`.name, DeleteMessageFeature.`get`.name, ComposeMessageFeature.`get`.name, SpamableFeature.`get`.name, MovableToFolderFeature.`get`.name, CreatableFolderFeature.`get`.name, WysiwygFeature.`get`.name, ArchiveMessageFeature.`get`.name, YandexLoginFeature.`get`.name, YandexTeamLoginFeature.`get`.name, MultiAccountFeature.`get`.name, ContextMenuFeature.`get`.name, ShortSwipeFeature.`get`.name, LongSwipeFeature.`get`.name, SearchFeature.`get`.name, ZeroSuggestFeature.`get`.name, CreatableLabelFeature.`get`.name, LabelNavigatorFeature.`get`.name, FilterNavigatorFeature.`get`.name, ContainerGetterFeature.`get`.name, StoriesBlockFeature.`get`.name, AccountSettingsFeature.`get`.name, IosAccountSettingsFeature.`get`.name, AndroidAccountSettingsFeature.`get`.name, AboutSettingsFeature.`get`.name, GeneralSettingsFeature.`get`.name, IosGeneralSettingsFeature.`get`.name, AndroidGeneralSettingsFeature.`get`.name, RootSettingsFeature.`get`.name, IOSRootSettingsFeature.`get`.name, AndroidRootSettingsFeature.`get`.name, UndoFeature.`get`.name, MailRuLoginFeature.`get`.name, GoogleLoginFeature.`get`.name, OutlookLoginFeature.`get`.name, HotmailLoginFeature.`get`.name, RamblerLoginFeature.`get`.name, YahooLoginFeature.`get`.name, CustomMailServiceLoginFeature.`get`.name, PinFeature.`get`.name, ApplicationRunningStateFeature.`get`.name, AccountsListFeature.`get`.name, ExpiringTokenFeature.`get`.name, ManageableFolderFeature.`get`.name, ManageableLabelFeature.`get`.name, TabsFeature.`get`.name)
    }
}

