// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/mailbox-model-hasher.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.int64
import com.yandex.xplat.testopithecus.common.HashBuilder

public open class MailboxModelHasher {
    open fun getMailboxModelHash(model: MailboxModel): Long {
        val hashBuilder: HashBuilder = HashBuilder().addBoolean(model.rotatable.landscape).addInt64(model.messageNavigator.openedMessage)
        val selectedMessages = model.groupMode.selectedOrders
        if (selectedMessages != null) {
            hashBuilder.addInt64(MailboxModelHasher.getSelectedMessagesHash(selectedMessages))
        } else {
            hashBuilder.addBoolean(true)
        }
        hashBuilder.addInt(29)
        for (message in model.readOnlyExpandableThreads.expanded.values()) {
            hashBuilder.addInt64(message)
        }
        hashBuilder.addInt(23)
        if (!model.mailAppModelHandler.hasCurrentAccount()) {
            return hashBuilder.build()
        }
        val messagesDB = model.messageListDisplay.accountDataHandler.getCurrentAccount().messagesDB
        messagesDB.setMailDBHash(hashBuilder)
        hashBuilder.addString(model.containerGetter.getCurrentContainer().name)
        return hashBuilder.build()
    }

    companion object {
        @JvmStatic
        private fun getSelectedMessagesHash(selectedMessages: YSSet<Int>): Long {
            val hashBuilder: HashBuilder = HashBuilder()
            hashBuilder.addInt(11)
            for (v in selectedMessages.values()) {
                hashBuilder.addInt64(int64(v))
            }
            return hashBuilder.build()
        }

    }
}

