// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/base-models/archive-message-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSMap
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.set
import com.yandex.xplat.testopithecus.common.currentTimeMs

public open class ArchiveMessageModel(private var model: MessageListDisplayModel, private var accHandler: MailAppModelHandler): ArchiveMessage {
    private var lastArchiveMessageTime: Long? = null
    private var archivedMessageIdToFolder: YSMap<MessageId, FolderName> = mutableMapOf<MessageId, FolderName>()
    open fun resetLastArchiveMessageTime(): Unit {
        this.lastArchiveMessageTime = null
    }

    open fun getLastArchiveMessageTime(): Long? {
        return this.lastArchiveMessageTime
    }

    open fun getArchivedMessageIdToFolder(): YSMap<MessageId, FolderName> {
        return this.archivedMessageIdToFolder
    }

    open override fun archiveMessage(order: Int): Unit {
        this.archiveMessages(YSSet<Int>(mutableListOf(order)))
    }

    open fun archiveMessages(orders: YSSet<Int>): Unit {
        if (!this.accHandler.getCurrentAccount().messagesDB.getFolderList().contains(DefaultFolderName.archive)) {
            this.accHandler.getCurrentAccount().messagesDB.createFolder(DefaultFolderName.archive)
        }
        this.archivedMessageIdToFolder.clear()
        for (mid in this.model.getMidsByOrders(orders)) {
            val folderName = this.accHandler.getCurrentAccount().messagesDB.storedFolder(mid)
            this.archivedMessageIdToFolder.set(mid, folderName)
            this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, DefaultFolderName.archive)
        }
        this.lastArchiveMessageTime = currentTimeMs()
    }

}

