// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/base-models/label-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet

public open class MarkableImportantModel(private var model: MessageListDisplayModel, private var accHandler: MailAppModelHandler): MarkableImportant {
    open override fun markAsImportant(order: Int): Unit {
        for (mid in this.model.getThreadByOrder(order)) {
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.important = true
        }
    }

    open override fun markAsUnimportant(order: Int): Unit {
        for (mid in this.model.getThreadByOrder(order)) {
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.important = false
        }
    }

}

public open class LabelModel(private var accHandler: MailAppModelHandler): CreatableLabel {
    open fun applyLabelsToMessages(mids: YSSet<MessageId>, labelNames: YSArray<LabelName>): Unit {
        labelNames.forEach(__LBL__LabelModel_1@ {
            labelName ->
            if (!this.accHandler.getCurrentAccount().messagesDB.getLabelList().contains(labelName)) {
                resolveThrow( {
                     ->
                    this.createLabel(labelName)
                }
, null)
            }
            this.accHandler.getCurrentAccount().messagesDB.applyLabelToMessages(labelName, mids)
        })
    }

    open fun removeLabelsFromMessages(mids: YSSet<MessageId>, labelNames: YSArray<LabelName>): Unit {
        labelNames.forEach(__LBL__LabelModel_2@ {
            labelName ->
            this.accHandler.getCurrentAccount().messagesDB.removeLabelFromMessages(labelName, mids)
        })
    }

    open fun getMessageLabels(mid: MessageId): YSSet<String> {
        return this.accHandler.getCurrentAccount().messagesDB.getMessageLabels(mid)
    }

    open override fun createLabel(labelName: String): Unit {
        this.accHandler.getCurrentAccount().messagesDB.createLabel(labelName)
    }

    open override fun removeLabel(labelName: String): Unit {
        this.accHandler.getCurrentAccount().messagesDB.removeLabel(labelName)
    }

}

