// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/base-models/spamable-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.testopithecus.common.currentTimeMs

public open class SpamableModel(private var model: MessageListDisplayModel, private var accHandler: MailAppModelHandler): Spamable {
    private var lastSpamActionTime: Long? = null
    private var spammedMessageIdToFolder: YSMap<MessageId, FolderName> = mutableMapOf<MessageId, FolderName>()
    private var midToReadStatus: YSMap<MessageId, Boolean> = mutableMapOf<MessageId, Boolean>()
    open fun resetLastSpamMessageTime(): Unit {
        this.lastSpamActionTime = null
    }

    open fun getLastSpamMessageTime(): Long? {
        return this.lastSpamActionTime
    }

    open fun getSpammedMessageIdToFolder(): YSMap<MessageId, FolderName> {
        return this.spammedMessageIdToFolder
    }

    open fun getMidToReadStatus(): YSMap<MessageId, Boolean> {
        return this.midToReadStatus
    }

    open override fun moveToSpam(order: Int): Unit {
        this.moveToSpamMessages(YSSet<Int>(mutableListOf(order)))
    }

    open fun moveToSpamMessages(orders: YSSet<Int>): Unit {
        val mids: YSArray<MessageId> = mutableListOf()
        this.spammedMessageIdToFolder.clear()
        this.midToReadStatus.clear()
        for (order in orders.values()) {
            this.model.getThreadByOrder(order).forEach( {
                mid ->
                mids.add(mid)
            })
        }
        val notSpamMessages = this.accHandler.getCurrentAccount().messagesDB.getMessages().filter( {
            mid ->
            !mids.contains(mid)
        })
        for (mid in mids) {
            val folderName = this.accHandler.getCurrentAccount().messagesDB.storedFolder(mid)
            this.spammedMessageIdToFolder.set(mid, folderName)
            this.midToReadStatus.set(mid, this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.read)
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.read = true
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.threadCounter = null
            this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, DefaultFolderName.spam)
            for (itemMid in notSpamMessages) {
                val threadCounter = this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.threadCounter
                if (this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.subject == this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.subject && threadCounter != null) {
                    this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.threadCounter = threadCounter - 1
                }
            }
        }
        this.lastSpamActionTime = currentTimeMs()
    }

    open override fun moveFromSpam(order: Int): Unit {
        this.moveFromSpamMessages(YSSet<Int>(mutableListOf(order)))
    }

    open fun addThreadCounter(notSpamMessages: YSArray<MessageId>, mid: MessageId): Unit {
        var threadCounter: Int = 1
        for (itemMid in notSpamMessages) {
            if (this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.subject == this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.subject) {
                val counter = this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.threadCounter
                this.accHandler.getCurrentAccount().messagesDB.storedMessage(itemMid).mutableHead.threadCounter = if (counter == null) 2 else counter + 1
                threadCounter = threadCounter + 1
            }
        }
        this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.threadCounter = if (threadCounter != 1) threadCounter else null
    }

    open fun moveFromSpamMessages(orders: YSSet<Int>, folder: FolderName = DefaultFolderName.inbox): Unit {
        val notSpamMessages = this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withExcludedFolders(mutableListOf(DefaultFolderName.spam)))
        for (mid in this.model.getMidsByOrders(orders)) {
            this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, folder)
            this.addThreadCounter(notSpamMessages, mid)
        }
        this.resetLastSpamMessageTime()
    }

}

