// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/compose/compose-message-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.filter
import com.yandex.xplat.common.setToArray
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class Draft(var wysiwig: WysiwygModel): DraftView {
    override var subject: String? = ""
    override var to: YSSet<String> = YSSet<String>()
    open override fun tostring(): String {
        val subj = if (this.subject != null) this.subject!! else ""
        var tos = ""
        for (to in this.to.values()) {
            tos += "${to},"
        }
        var body = ""
        try {
            val wysiwyg = this.getWysiwyg()
            body = wysiwyg.getRichBody()
        } catch (e: RuntimeException) {
        }
        return "Compose(to=${tos}, subject=${subj}, body=${body})"
    }

    open fun copy(): Draft {
        val copy = Draft(this.wysiwig)
        copy.subject = this.subject
        copy.to = this.to
        return copy
    }

    open override fun getWysiwyg(): WysiwygView {
        return Wysiwyg(this.wysiwig)
    }

    companion object {
        @JvmStatic
        open fun matches(first: DraftView, second: DraftView): Boolean {
            val firstBody = resolveThrow(__LBL__ComposeMessageModel_1@ {
                 ->
                val firstWysiwyg = first.getWysiwyg()
                return@__LBL__ComposeMessageModel_1 firstWysiwyg.getRichBody()
            }
, "")
            val secondBody = resolveThrow(__LBL__ComposeMessageModel_2@ {
                 ->
                val secondWysiwyg = second.getWysiwyg()
                return@__LBL__ComposeMessageModel_2 secondWysiwyg.getRichBody()
            }
, "")
            try {
                return firstBody == secondBody && first.subject == second.subject && Draft.isToEquals(first.to, second.to)
            } catch (e: RuntimeException) {
                return false
            }
        }

        @JvmStatic
        open fun isToEquals(first: YSSet<String>, second: YSSet<String>): Boolean {
            if (first.size != second.size) {
                return false
            }
            for (a in first.values()) {
                if (!second.has(a)) {
                    return false
                }
            }
            return true
        }

    }
}

public open class Wysiwyg(var wysiwig: WysiwygModel): WysiwygView {
    open override fun getStyles(i: Int): YSSet<String> {
        return this.wysiwig.getStyles()[i]
    }

    open override fun getText(): String {
        return this.wysiwig.getSymbols().joinToString("")
    }

    open override fun getRichBody(): String {
        return this.wysiwig.getBody()
    }

}

public open class ComposeMessageModel(private var wysiwyg: WysiwygModel, private val accountDataHandler: MailAppModelHandler): ComposeMessage {
    var composeDraft: Draft? = null
    open override fun getDraft(): DraftView {
        return this.demandDraft()
    }

    open override fun goToMessageReply(): Unit {
        this.composeDraft = Draft(this.wysiwyg)
    }

    open override fun setBody(body: String): Unit {
        val draft = this.demandDraft()
        this.clearBody()
        draft.wysiwig.appendText(0, body)
    }

    open override fun setSubject(subject: String): Unit {
        this.demandDraft().subject = subject
    }

    open override fun addTo(to: String): Unit {
        this.demandDraft().to.add(to)
    }

    open override fun addToUsingSuggest(to: String): Unit {
        this.demandDraft().to.add(this.accountDataHandler.getCurrentAccount().contacts.filter( {
            contact ->
            contact.startsWith(to)
        })[0])
    }

    open fun openCompose(): Unit {
        this.composeDraft = Draft(this.wysiwyg)
    }

    open override fun getTo(): YSSet<String> {
        return this.getDraft().to
    }

    open override fun clearBody(): Unit {
        this.demandDraft().wysiwig.clear()
    }

    open override fun clearSubject(): Unit {
        this.demandDraft().subject = null
    }

    open override fun removeTo(order: Int): Unit {
        var toToDelete = ""
        var currentToNumber = 0
        for (to in setToArray(this.demandDraft().to)) {
            if (currentToNumber == order) {
                toToDelete = to
                break
            }
            currentToNumber += 1
        }
        this.demandDraft().to.delete(toToDelete)
    }

    private fun demandDraft(): Draft {
        return requireNonNull(this.composeDraft, "Draft wasn't created!")
    }

}

