// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/left-column/manage-folders-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.split
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class ManageFoldersModel(private var accHandler: MailAppModelHandler): ManageableFolder {
    private var nameOfCreatedFolder: FolderName? = null
    private var oldNameOfEditedFolder: FolderName? = null
    private var oldParentFoldersOfEditedFolder: YSArray<FolderName> = mutableListOf()
    private var newNameOfEditedFolder: FolderName? = null
    private var parentFolders: YSArray<FolderName> = mutableListOf()
    open override fun closeFolderManager(): Unit {
    }

    open override fun openFolderManager(): Unit {
    }

    open override fun deleteFolder(folderDisplayName: FolderName, parentFolders: YSArray<FolderName>, deletionMethod: ContainerDeletionMethod): Unit {
        this.accHandler.getCurrentAccount().messagesDB.removeFolder(formatFolderName(folderDisplayName, parentFolders))
        val folders = this.accHandler.getCurrentAccount().messagesDB.getUserFolders()
        for (folder in folders) {
            if (folder.split("${folderDisplayName}|").size > 1) {
                this.accHandler.getCurrentAccount().messagesDB.removeFolder(folder)
            }
        }
    }

    open override fun getFolderListForManageFolderScreen(): YSArray<FolderName> {
        return this.accHandler.getCurrentAccount().messagesDB.getUserFolders()
    }

    open override fun closeCreateFolderScreen(): Unit {
        this.dropAll()
    }

    open override fun closeEditFolderScreen(): Unit {
        this.dropAll()
    }

    open override fun closeFolderLocationScreen(): Unit {
        this.parentFolders = mutableListOf()
    }

    open override fun enterNameForNewFolder(folderName: FolderName): Unit {
        this.nameOfCreatedFolder = folderName
    }

    open override fun enterNameForEditedFolder(folderName: FolderName): Unit {
        this.newNameOfEditedFolder = folderName
    }

    open override fun getFolderListForFolderLocationScreen(): YSArray<FolderName> {
        val userFolders = this.accHandler.getCurrentAccount().messagesDB.getUserFolders()
        userFolders.add(this.accHandler.getCurrentAccount().userAccount.login as FolderName)
        return userFolders
    }

    open override fun openCreateFolderScreen(): Unit {
    }

    open override fun openEditFolderScreen(folderName: FolderName, parentFolders: YSArray<FolderName>): Unit {
        this.oldNameOfEditedFolder = folderName
        this.oldParentFoldersOfEditedFolder = parentFolders
    }

    open override fun openFolderLocationScreen(): Unit {
    }

    open override fun selectParentFolder(parentFolders: YSArray<FolderName>): Unit {
        this.parentFolders = parentFolders
    }

    open override fun submitNewFolder(): Unit {
        this.accHandler.getCurrentAccount().messagesDB.createFolder(formatFolderName(requireNonNull(this.nameOfCreatedFolder, "Folder name is not set"), this.parentFolders))
        this.dropAll()
    }

    open override fun submitEditedFolder(): Unit {
        this.accHandler.getCurrentAccount().messagesDB.renameFolder(formatFolderName(requireNonNull(this.oldNameOfEditedFolder, "Old folder name is not set"), this.oldParentFoldersOfEditedFolder), formatFolderName(requireNonNull(this.newNameOfEditedFolder, "New folder name is not set"), this.parentFolders))
        this.dropAll()
    }

    open override fun getCurrentParentFolderForEditedFolder(): String {
        if (this.parentFolders.size == 0 && this.oldParentFoldersOfEditedFolder.size == 0) {
            return this.accHandler.getCurrentAccount().userAccount.login
        } else if (this.parentFolders.size == 0) {
            return this.oldParentFoldersOfEditedFolder[this.oldParentFoldersOfEditedFolder.size - 1]
        } else {
            return this.parentFolders[this.parentFolders.size - 1]
        }
    }

    open override fun getCurrentParentFolderForNewFolder(): String {
        if (this.parentFolders.size == 0) {
            return this.accHandler.getCurrentAccount().userAccount.login
        } else {
            return this.parentFolders[this.parentFolders.size - 1]
        }
    }

    open override fun getCurrentEditedFolderName(): FolderName {
        if (this.newNameOfEditedFolder == null) {
            return this.oldNameOfEditedFolder!!
        }
        return this.newNameOfEditedFolder!!
    }

    open override fun getCurrentNewFolderName(): FolderName {
        if (this.nameOfCreatedFolder == null) {
            return ""
        }
        return this.nameOfCreatedFolder!!
    }

    private fun dropAll(): Unit {
        this.oldNameOfEditedFolder = null
        this.oldParentFoldersOfEditedFolder = mutableListOf()
        this.newNameOfEditedFolder = null
        this.parentFolders = mutableListOf()
    }

}

