// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/messages-list/expandable-threads-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.map

public open class ReadOnlyExpandableThreadsModel(private var messageListDisplay: MessageListDisplayModel, private var accHandler: MailAppModelHandler): ReadOnlyExpandableThreads {
    var expanded: YSSet<MessageId> = YSSet<MessageId>()
    open override fun isExpanded(threadOrder: Int): Boolean {
        val mid = this.messageListDisplay.getMessageId(threadOrder)
        return this.expanded.has(mid)
    }

    open override fun isRead(threadOrder: Int, messageOrder: Int): Boolean {
        return this.getThreadMessage(threadOrder, messageOrder).head.read
    }

    open override fun getMessagesInThread(threadOrder: Int): YSArray<MessageView> {
        return this.accHandler.getCurrentAccount().messagesDB.getMessagesInThreadByMid(this.messageListDisplay.getMessageId(threadOrder)).map( {
            mid ->
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).head
        })
    }

    open fun getThreadMessage(threadOrder: Int, messageOrder: Int): FullMessage {
        val mid = this.getMessagesInThreadByOrder(threadOrder)[messageOrder]
        return this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid)
    }

    private fun getMessagesInThreadByOrder(threadOrder: Int): YSArray<MessageId> {
        val mid = this.messageListDisplay.getMessageId(threadOrder)
        return this.accHandler.getCurrentAccount().messagesDB.getMessagesInThreadByMid(mid)
    }

}

public open class ExpandableThreadsModel(private var readonlyExpandableThreads: ReadOnlyExpandableThreadsModel, private var messageListDisplay: MessageListDisplayModel): ExpandableThreads {
    open override fun markThreadMessageAsRead(threadOrder: Int, messageOrder: Int): Unit {
        this.readonlyExpandableThreads.getThreadMessage(threadOrder, messageOrder).mutableHead.read = true
    }

    open override fun markThreadMessageAsUnRead(threadOrder: Int, messageOrder: Int): Unit {
        this.readonlyExpandableThreads.getThreadMessage(threadOrder, messageOrder).mutableHead.read = false
    }

    open fun markThreadMessageAsImportant(threadOrder: Int, messageOrder: Int): Unit {
        this.readonlyExpandableThreads.getThreadMessage(threadOrder, messageOrder).mutableHead.important = true
    }

    open fun markThreadMessageAsUnimportant(threadOrder: Int, messageOrder: Int): Unit {
        this.readonlyExpandableThreads.getThreadMessage(threadOrder, messageOrder).mutableHead.important = false
    }

    open override fun expandThread(order: Int): Unit {
        val mid = this.messageListDisplay.getMessageId(order)
        this.readonlyExpandableThreads.expanded.add(mid)
    }

    open override fun collapseThread(order: Int): Unit {
        val mid = this.messageListDisplay.getMessageId(order)
        this.readonlyExpandableThreads.expanded.delete(mid)
    }

}

