// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/messages-list/message-list-display-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.testopithecus.common.fail

public open class MessageListDisplayModel(var accountDataHandler: MailAppModelHandler): MessageListDisplay {
    private var currentContainer: MessageContainer = MessageContainer(DefaultFolderName.inbox, MessageContainerType.folder)
    private var listeners: YSArray<ContainerListener> = mutableListOf()
    var messageListFilter: MessageListDatabaseFilter
    init {
        this.messageListFilter = MessageListDatabaseFilter()
    }
    open fun getCurrentContainer(): MessageContainer {
        return this.currentContainer
    }

    open fun setCurrentContainer(container: MessageContainer): Unit {
        this.currentContainer = container
        this.messageListFilter = MessageListDatabaseFilter()
        this.notifyContainerChanged()
    }

    open fun attach(listener: ContainerListener): Unit {
        this.listeners.add(listener)
    }

    open fun notifyContainerChanged(): Unit {
        for (listener in this.listeners) {
            listener.containerChanged(this.currentContainer)
        }
    }

    open override fun getMessageList(limit: Int): YSArray<MessageView> {
        val messageList = this.accountDataHandler.getCurrentAccount().messagesDB.getMessageList(this.messageListFilter.withContainer(this.currentContainer).withIsInThreadMode(this.isInThreadMode()).withLimit(limit))
        if (this.currentContainer.name == DefaultFolderName.sent || this.currentContainer.name == DefaultFolderName.draft) {
            for (i in (0 until messageList.size step 1)) {
                messageList[i].from = messageList[i].to
            }
        }
        if (this.isInThreadMode()) {
            return messageList
        }
        for (i in (0 until messageList.size step 1)) {
            messageList[i].threadCounter = null
        }
        return messageList
    }

    open fun getMessageIdList(limit: Int): YSArray<MessageId> {
        return this.accountDataHandler.getCurrentAccount().messagesDB.getMessageIdList(this.messageListFilter.withContainer(this.currentContainer).withIsInThreadMode(this.isInThreadMode()).withLimit(limit))
    }

    open override fun refreshMessageList(): Unit {
        return
    }

    open override fun unreadCounter(): Int {
        throw Error("Not implemented")
    }

    open fun getMessageId(order: Int): MessageId {
        val messageIds = this.getMessageIdList(order + 1)
        if (order >= messageIds.size) {
            fail("No message with order ${order}")
        }
        return messageIds[order]
    }

    open fun isInThreadMode(): Boolean {
        val notThreadableFolders: YSArray<String> = mutableListOf(DefaultFolderName.outgoing, DefaultFolderName.draft, DefaultFolderName.trash, DefaultFolderName.spam, DefaultFolderName.archive)
        if (this.currentContainer.type == MessageContainerType.folder && notThreadableFolders.contains(this.getCurrentContainer().name)) {
            return false
        }
        if (mutableListOf(MessageContainerType.search, MessageContainerType.unreadFilter, MessageContainerType.importantFilter, MessageContainerType.label).contains(this.currentContainer.type)) {
            return false
        }
        return this.accountDataHandler.getCurrentAccount().accountSettings.groupBySubjectEnabled
    }

    open fun isInTabsMode(): Boolean {
        return this.accountDataHandler.getCurrentAccount().accountSettings.sortingEmailsByCategoryEnabled
    }

    open override fun goToAccountSwitcher(): Unit {
    }

    open fun getMidsByOrders(orders: YSSet<Int>): YSArray<MessageId> {
        val mids: YSArray<MessageId> = mutableListOf()
        val messageListMids: YSArray<MessageId> = mutableListOf()
        orders.forEach( {
            order ->
            messageListMids.add(this.getMessageId(order))
        })
        for (messageListMid in messageListMids) {
            for (mid in this.accountDataHandler.getCurrentAccount().messagesDB.getMessagesInThreadByMid(messageListMid)) {
                mids.add(mid)
            }
        }
        return mids
    }

    open fun getThreadByOrder(order: Int): YSArray<MessageId> {
        if (!this.isInThreadMode()) {
            return mutableListOf(this.getMessageId(order))
        }
        return this.accountDataHandler.getCurrentAccount().messagesDB.getMessagesInThreadByMid(this.getMessageId(order))
    }

}

public interface ContainerListener {
    fun containerChanged(container: MessageContainer): Unit
}

