// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/messages-list/undo-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.__forEach
import com.yandex.xplat.testopithecus.common.currentTimeMs

public open class UndoModel(private var deleteModel: DeleteMessageModel, private var archiveModel: ArchiveMessageModel, private var spamModel: SpamableModel, private var accHandler: MailAppModelHandler, private var messageListDisplayModel: MessageListDisplayModel): Undo {
    open fun resetUndoShowing(): Unit {
        this.deleteModel.resetLastDeleteMessageTime()
        this.archiveModel.resetLastArchiveMessageTime()
        this.spamModel.resetLastSpamMessageTime()
    }

    open override fun isUndoArchiveToastShown(): UndoState {
        val lastArchiveMessageTime = this.archiveModel.getLastArchiveMessageTime()
        if (lastArchiveMessageTime == null) {
            return UndoState.notShown
        }
        val duration = currentTimeMs() - lastArchiveMessageTime!!
        return this.getUndoToastShowingState(duration)
    }

    open override fun isUndoDeleteToastShown(): UndoState {
        val lastDeleteMessageTime = this.deleteModel.getLastDeleteMessageTime()
        if (lastDeleteMessageTime == null || this.messageListDisplayModel.getCurrentContainer().name == DefaultFolderName.trash) {
            return UndoState.notShown
        }
        val duration = currentTimeMs() - lastDeleteMessageTime!!
        return this.getUndoToastShowingState(duration)
    }

    open override fun isUndoSpamToastShown(): UndoState {
        val lastSpamMessageTime = this.spamModel.getLastSpamMessageTime()
        if (lastSpamMessageTime == null) {
            return UndoState.notShown
        }
        val duration = currentTimeMs() - lastSpamMessageTime!!
        return this.getUndoToastShowingState(duration)
    }

    open override fun isUndoSendingToastShown(): UndoState {
        return UndoState.notShown
    }

    open override fun undoArchive(): Unit {
        val archivedMessageIdToFolder = this.archiveModel.getArchivedMessageIdToFolder()
        archivedMessageIdToFolder.__forEach(__LBL__UndoModel_1@ {
            folderName, mid ->
            this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, folderName)
        })
        this.archiveModel.resetLastArchiveMessageTime()
    }

    open override fun undoDelete(): Unit {
        val deletedMessageIdToFolder = this.deleteModel.getDeletedMessageIdToFolder()
        deletedMessageIdToFolder.__forEach(__LBL__UndoModel_2@ {
            folderName, mid ->
            if (folderName != DefaultFolderName.trash) {
                this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, folderName)
            }
        })
        this.deleteModel.resetLastDeleteMessageTime()
    }

    open override fun undoSpam(): Unit {
        val spammedMessageIdToFolder = this.spamModel.getSpammedMessageIdToFolder()
        val midToReadStatus = this.spamModel.getMidToReadStatus()
        val notSpamMessages = this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withExcludedFolders(mutableListOf(DefaultFolderName.spam)))
        spammedMessageIdToFolder.__forEach(__LBL__UndoModel_3@ {
            folderName, mid ->
            this.accHandler.getCurrentAccount().messagesDB.storedMessage(mid).mutableHead.read = midToReadStatus.`get`(mid)!!
            this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(mid, folderName)
            this.spamModel.addThreadCounter(notSpamMessages, mid)
            notSpamMessages.add(mid)
        })
        this.spamModel.resetLastSpamMessageTime()
    }

    open override fun undoSending(): Unit {
    }

    private fun getUndoToastShowingState(duration: Long): UndoState {
        val SHOWING_DURATION = 5000
        val TIMING_MARGIN = 10000
        if (duration <= SHOWING_DURATION) {
            return UndoState.shown
        } else if (duration > SHOWING_DURATION && duration <= TIMING_MARGIN) {
            return UndoState.undefined
        } else {
            return UndoState.notShown
        }
    }

}

