// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/opened-message/open-message-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSSet
import com.yandex.xplat.common.int64
import com.yandex.xplat.common.unshift
import com.yandex.xplat.testopithecus.common.fail
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class OpenMessageModel(private var markableRead: MarkableRead, private var markableImportant: MarkableImportant, private var expandableThreads: ExpandableThreads, private var messageListDisplay: MessageListDisplayModel, private var creatableLabel: LabelModel, private var deleteMessageModel: DeleteMessageModel, private var accHandler: MailAppModelHandler): MessageViewer, ThreadViewNavigator {
    var openedMessage: MessageId = int64(-1)
    private var order: Int? = null
    open override fun closeMessage(): Unit {
        this.openedMessage = int64(-1)
        this.order = null
    }

    open override fun deleteCurrentMessage(): Unit {
        val openedMessage = this.openedMessage
        if (openedMessage == int64(-1)) {
            fail("No opened message!")
        }
        this.closeMessage()
        this.deleteMessageModel.deleteOpenedMessage(openedMessage)
    }

    open override fun deleteCurrentThread(): Unit {
        this.deleteMessageModel.deleteMessage(requireNonNull(this.order, "No opened message!"))
        this.closeMessage()
    }

    open override fun openMessage(order: Int): Unit {
        this.order = order
        if (this.messageListDisplay.getCurrentContainer().type == MessageContainerType.search) {
            this.accHandler.getCurrentAccount().zeroSuggest.unshift(this.messageListDisplay.getCurrentContainer().name)
        }
        this.expandableThreads.markThreadMessageAsRead(order, 0)
        this.openedMessage = this.messageListDisplay.getMessageId(order)
    }

    open override fun getOpenedMessage(): FullMessageView {
        return this.accHandler.getCurrentAccount().messagesDB.storedMessage(this.openedMessage)
    }

    open override fun markAsRead(): Unit {
        this.markableRead.markAsRead(requireNonNull(this.order, "No opened message!"))
    }

    open override fun markAsUnread(): Unit {
        this.markableRead.markAsUnread(requireNonNull(this.order, "No opened message!"))
    }

    open override fun checkIfRead(): Boolean {
        return this.accHandler.getCurrentAccount().messagesDB.storedMessage(this.openedMessage).head.read
    }

    open override fun addLabels(labels: YSArray<LabelName>): Unit {
        this.creatableLabel.applyLabelsToMessages(YSSet(mutableListOf(this.openedMessage)), labels)
    }

    open override fun deleteLabels(labels: YSArray<LabelName>): Unit {
        this.creatableLabel.removeLabelsFromMessages(YSSet(mutableListOf(this.openedMessage)), labels)
    }

    open override fun getLabels(): YSSet<String> {
        return this.creatableLabel.getMessageLabels(this.openedMessage)
    }

    open override fun moveMessageToFolder(folderName: FolderName): Unit {
        this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(this.openedMessage, folderName)
    }

    open override fun archive(): Unit {
        this.moveMessageToFolder(DefaultFolderName.archive)
    }

    open override fun checkIfImportant(): Boolean {
        return this.accHandler.getCurrentAccount().messagesDB.storedMessage(this.openedMessage).head.important
    }

    open override fun markAsUnimportant(): Unit {
        this.markableImportant.markAsUnimportant(requireNonNull(this.order, "No opened message!"))
    }

    open override fun markAsImportant(): Unit {
        this.markableImportant.markAsImportant(requireNonNull(this.order, "No opened message!"))
    }

    open override fun checkIfSpam(): Boolean {
        if (!this.accHandler.getCurrentAccount().messagesDB.getFolderList().contains(DefaultFolderName.spam)) {
            return false
        }
        return this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withFolder(DefaultFolderName.spam)).contains(this.openedMessage)
    }

    open override fun markAsSpam(): Unit {
        this.moveMessageToFolder(DefaultFolderName.spam)
    }

    open override fun unmarkAsSpam(): Unit {
        this.moveMessageToFolder(DefaultFolderName.inbox)
    }

    open override fun deleteLabelsFromHeader(labels: YSArray<LabelName>): Unit {
        this.deleteLabels(labels)
    }

    open override fun markAsUnimportantFromHeader(): Unit {
        this.markAsUnimportant()
    }

}

