// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/search/search-model.ts >>>

package com.yandex.xplat.testopithecus

public open class SearchModel(private var messageList: MessageListDisplayModel): Search {
    private var isSearchOpened: Boolean
    private var lastContainer: MessageContainer
    init {
        this.isSearchOpened = false
        this.lastContainer = this.messageList.getCurrentContainer()
    }
    open override fun searchAllMessages(): Unit {
        this.searchByQuery("yandex")
    }

    open override fun searchByQuery(query: String): Unit {
        this.messageList.setCurrentContainer(MessageContainer(query, MessageContainerType.search))
    }

    open override fun closeSearch(): Unit {
        this.isSearchOpened = false
        this.messageList.setCurrentContainer(this.lastContainer)
    }

    open override fun clearTextField(): Unit {
        this.messageList.setCurrentContainer(this.lastContainer)
    }

    open override fun isInSearch(): Boolean {
        return this.isSearchOpened
    }

    open override fun isSearchedForMessages(): Boolean {
        return this.messageList.getCurrentContainer().type == MessageContainerType.search
    }

    open override fun openSearch(): Unit {
        this.lastContainer = this.messageList.getCurrentContainer()
        this.isSearchOpened = true
    }

}

