// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/settings/account-settings-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.YSArray
import com.yandex.xplat.common.YSMap
import com.yandex.xplat.common.set
import com.yandex.xplat.mapi.SignaturePlace
import com.yandex.xplat.testopithecus.common.AccountsManager
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class AccountSettingModel(val accountsSettings: YSArray<AccountSettingsModel>, val accountsManager: AccountsManager, private var accHandler: MailAppModelHandler, private var openedAccount: Int? = null): AccountSettings, AndroidAccountSettings, IosAccountSettings {
    open override fun openAccountSettings(accountIndex: Int): Unit {
        this.openedAccount = this.accountsManager.indexesOfLoggedInAccounts[accountIndex]
    }

    open override fun closeAccountSettings(): Unit {
        this.openedAccount = null
    }

    private fun getOpenedAccountSettings(): AccountSettingsModel {
        return this.accountsSettings[this.demandRequiredAccountIndex()]
    }

    open override fun isGroupBySubjectEnabled(): Boolean {
        return this.getOpenedAccountSettings().groupBySubjectEnabled
    }

    open override fun getFolderToNotificationOption(): YSMap<FolderName, NotificationOption> {
        return this.getOpenedAccountSettings().folderToNotificationOption
    }

    open override fun switchGroupBySubject(): Unit {
        this.getOpenedAccountSettings().groupBySubjectEnabled = !this.getOpenedAccountSettings().groupBySubjectEnabled
    }

    open override fun changePhoneNumber(newPhoneNumber: String): Unit {
        this.getOpenedAccountSettings().phoneNumber = newPhoneNumber
    }

    open override fun changeSignature(newSignature: String): Unit {
        this.getOpenedAccountSettings().signature = newSignature
    }

    open override fun getNotificationOptionForFolder(folder: FolderName): NotificationOption {
        return this.getOpenedAccountSettings().folderToNotificationOption.`get`(folder)!!
    }

    open override fun getPlaceForSignature(): SignaturePlace {
        return this.getOpenedAccountSettings().placeForSignature
    }

    open override fun getPushNotificationSound(): NotificationSound {
        return this.getOpenedAccountSettings().notificationSound
    }

    open override fun getSignature(): String {
        return this.getOpenedAccountSettings().signature
    }

    open override fun isAccountUsingEnabled(): Boolean {
        return this.getOpenedAccountSettings().accountUsingEnabled
    }

    open override fun isPushNotificationForAllEnabled(): Boolean {
        return this.getOpenedAccountSettings().pushNotificationForAllEnabled
    }

    open override fun isSortingEmailsByCategoryEnabled(): Boolean {
        return this.getOpenedAccountSettings().sortingEmailsByCategoryEnabled
    }

    open override fun isThemeEnabled(): Boolean {
        return this.getOpenedAccountSettings().themeEnabled
    }

    open override fun openFolderManager(): Unit {
    }

    open override fun openLabelManager(): Unit {
    }

    open override fun openMailingListsManager(): Unit {
    }

    open override fun openPassport(): Unit {
    }

    open override fun setNotificationOptionForFolder(folder: FolderName, option: NotificationOption): Unit {
        this.getOpenedAccountSettings().folderToNotificationOption.set(folder, option)
    }

    open override fun setPlaceForSignature(place: SignaturePlace): Unit {
        this.getOpenedAccountSettings().placeForSignature = place
    }

    open override fun setPushNotificationSound(sound: NotificationSound): Unit {
        this.getOpenedAccountSettings().notificationSound = sound
    }

    open override fun switchPushNotification(): Unit {
        val currentAccountSettings: AccountSettingsModel = this.getOpenedAccountSettings()
        currentAccountSettings.pushNotificationForAllEnabled = !currentAccountSettings.pushNotificationForAllEnabled
    }

    open override fun switchSortingEmailsByCategory(): Unit {
        val currentAccountSettings: AccountSettingsModel = this.getOpenedAccountSettings()
        currentAccountSettings.sortingEmailsByCategoryEnabled = !currentAccountSettings.sortingEmailsByCategoryEnabled
        if (currentAccountSettings.sortingEmailsByCategoryEnabled) {
            this.accHandler.getCurrentAccount().messagesDB.createFolder(DefaultFolderName.mailingLists)
            this.accHandler.getCurrentAccount().messagesDB.createFolder(DefaultFolderName.socialNetworks)
            val msgs = this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withFolder(DefaultFolderName.inbox))
            val msgInSocialMedia = this.accHandler.getCurrentAccount().messagesDB.getTabsToMessage(DefaultFolderName.socialNetworks)
            val msgInSubscriptions = this.accHandler.getCurrentAccount().messagesDB.getTabsToMessage(DefaultFolderName.mailingLists)
            for (index in (0 until msgs.size step 1)) {
                if (msgInSocialMedia.has(msgs[index])) {
                    this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(msgs[index], DefaultFolderName.socialNetworks)
                }
                if (msgInSubscriptions.has(msgs[index])) {
                    this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(msgs[index], DefaultFolderName.mailingLists)
                }
            }
        } else {
            var msgs = this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withFolder(DefaultFolderName.socialNetworks))
            for (index in (0 until msgs.size step 1)) {
                this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(msgs[index], DefaultFolderName.inbox, false)
            }
            msgs = this.accHandler.getCurrentAccount().messagesDB.getMessageIdList(MessageListDatabaseFilter().withFolder(DefaultFolderName.mailingLists))
            for (index in (0 until msgs.size step 1)) {
                this.accHandler.getCurrentAccount().messagesDB.moveMessageToFolder(msgs[index], DefaultFolderName.inbox, false)
            }
            this.accHandler.getCurrentAccount().messagesDB.removeFolder(DefaultFolderName.mailingLists)
            this.accHandler.getCurrentAccount().messagesDB.removeFolder(DefaultFolderName.socialNetworks)
        }
    }

    open override fun switchTheme(): Unit {
        val currentAccountSettings: AccountSettingsModel = this.getOpenedAccountSettings()
        currentAccountSettings.themeEnabled = !currentAccountSettings.themeEnabled
    }

    open override fun switchUseAccountSetting(): Unit {
        val currentAccountSettings: AccountSettingsModel = this.getOpenedAccountSettings()
        currentAccountSettings.accountUsingEnabled = !currentAccountSettings.accountUsingEnabled
    }

    private fun demandRequiredAccountIndex(): Int {
        return requireNonNull(this.openedAccount, "Необходимо зайти в настройки аккаунта")
    }

}

