// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/stories/stories-block-model.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.Log

public open class StoriesBlockModel(): StoriesBlock {
    var hideClickedFlag: Boolean = false
    var displaysLeft: Int = 10
    var container: MessageContainer? = null
    open override fun hideStories(): Unit {
        Log.info("Hiding all stories")
        this.hideClickedFlag = true
    }

    open override fun openStory(position: Int): Unit {
        Log.info("Opening story at ${position} position")
    }

    open override fun isHidden(): Boolean {
        return (this.hideClickedFlag || this.displaysLeft < 0 || !(this.container != null && this.container!!.type == MessageContainerType.folder && this.container!!.name == DefaultFolderName.inbox))
    }

    open fun blockShown(): Unit {
        if (this.displaysLeft >= 0) {
            this.displaysLeft = this.displaysLeft - 1
        }
    }

}

public open class StoriesBlockViewCounter(private var model: StoriesBlockModel, private var messageListDisplayModel: MessageListDisplayModel): RotateListener, ContainerListener {
    init {
        this.model.container = messageListDisplayModel.getCurrentContainer()
    }
    open fun blockShown(): Unit {
        this.model.blockShown()
    }

    open fun folderOpened(container: MessageContainer): Unit {
        this.model.container = container
        if (container.type == MessageContainerType.folder && container.name == DefaultFolderName.inbox) {
            this.blockShown()
        }
    }

    open override fun rotated(landscape: Boolean): Unit {
        this.folderOpened(this.messageListDisplayModel.getCurrentContainer())
    }

    open override fun containerChanged(container: MessageContainer): Unit {
        this.folderOpened(container)
    }

}

