// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/supplementary/message-list-database.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.common.*
import com.yandex.xplat.testopithecus.common.HashBuilder
import com.yandex.xplat.testopithecus.common.fail
import com.yandex.xplat.testopithecus.common.requireNonNull

public open class MessageListDatabase(private val messages: YSMap<MessageId, FullMessage>, private val folderToMessages: YSMap<FolderName, YSSet<MessageId>>, private val labelToMessages: YSMap<LabelName, YSSet<MessageId>>, private var tabsToMessages: YSMap<FolderName, YSSet<MessageId>>, private var threads: YSArray<YSSet<MessageId>>) {
    init {
        this.tabsToMessages.set(DefaultFolderName.inbox, YSSet<MessageId>())
        this.tabsToMessages.set(DefaultFolderName.socialNetworks, YSSet<MessageId>())
        this.tabsToMessages.set(DefaultFolderName.mailingLists, YSSet<MessageId>())
    }
    open fun setMailDBHash(builder: HashBuilder): Unit {
        for (thread in this.threads) {
            builder.addInt(19)
            for (message in thread.values()) {
                builder.addInt64(message)
            }
        }
        builder.addInt(17)
        this.messages.__forEach(__LBL__MessageListDatabase_1@ {
            message, id ->
            builder.addInt64(id).addInt64(this.getMessageHash(message))
        })
        builder.addInt(13)
        this.folderToMessages.__forEach(__LBL__MessageListDatabase_2@ {
            ids, folder ->
            for (id in ids.values()) {
                builder.addInt64(id).addString(folder)
            }
        })
    }

    open fun copy(): MessageListDatabase {
        val messagesCopy = mutableMapOf<MessageId, FullMessage>()
        for (mid in this.messages.keys()) {
            messagesCopy.set(mid, this.messages.`get`(mid)!!.copy())
        }
        val threadsCopy: YSArray<YSSet<MessageId>> = mutableListOf()
        this.threads.forEach(__LBL__MessageListDatabase_3@ {
            thread ->
            val threadCopy = YSSet(thread)
            threadsCopy.add(threadCopy)
        })
        val folderToMessagesCopy: YSMap<FolderName, YSSet<MessageId>> = mutableMapOf<FolderName, YSSet<MessageId>>()
        this.folderToMessages.__forEach( {
            mids, folderName ->
            folderToMessagesCopy.set(folderName, YSSet(mids))
        })
        val labelToMessagesCopy: YSMap<LabelName, YSSet<MessageId>> = mutableMapOf<LabelName, YSSet<MessageId>>()
        this.labelToMessages.__forEach( {
            lids, labelName ->
            labelToMessagesCopy.set(labelName, YSSet(lids))
        })
        val tabsToMessagesCopy: YSMap<FolderName, YSSet<MessageId>> = mutableMapOf<FolderName, YSSet<MessageId>>()
        this.tabsToMessages.__forEach( {
            mids, folderName ->
            tabsToMessagesCopy.set(folderName, YSSet(mids))
        })
        return MessageListDatabase(messagesCopy, folderToMessagesCopy, labelToMessagesCopy, tabsToMessagesCopy, threadsCopy)
    }

    open fun getTabsToMessage(folderName: FolderName): YSSet<MessageId> {
        if (!this.tabsToMessages.has(folderName)) {
            fail("Это папка не таб!")
        }
        val messages = undefinedToNull(this.tabsToMessages.get(folderName))
        return messages!!
    }

    open fun getLabelList(): YSArray<LabelName> {
        val labels: YSArray<LabelName> = mutableListOf()
        this.labelToMessages.__forEach( {
            mids, label ->
            labels.add(label)
        })
        return labels
    }

    open fun getFolderList(): YSArray<FolderName> {
        val folders: YSArray<FolderName> = mutableListOf()
        this.folderToMessages.__forEach( {
            mids, folder ->
            folders.add(folder)
        })
        return folders
    }

    open fun getUserFolders(): YSArray<FolderName> {
        val excludedFolders = mutableListOf(DefaultFolderName.inbox, DefaultFolderName.socialNetworks, DefaultFolderName.mailingLists, DefaultFolderName.trash, DefaultFolderName.sent, DefaultFolderName.archive, DefaultFolderName.spam, DefaultFolderName.outgoing, DefaultFolderName.draft, DefaultFolderName.template)
        return this.getFolderList().filter( {
            folderName ->
            !excludedFolders.contains(folderName)
        })
    }

    open fun getMessages(): YSArray<MessageId> {
        val messages: YSArray<MessageId> = mutableListOf()
        this.messages.__forEach( {
            msg, mid ->
            messages.add(mid)
        })
        return messages
    }

    open fun getMessageIdList(filter: MessageListDatabaseFilter): YSArray<MessageId> {
        val filteredMessages: YSArray<MessageId> = mutableListOf()
        this.messages.__forEach(__LBL__MessageListDatabase_4@ {
            _, mid ->
            if (this.isMessageInFilter(mid, filter)) {
                filteredMessages.add(mid)
            }
        })
        return this.buildMessageIdList(filteredMessages, filter.getLimit(), filter.getIsInThreadMode())
    }

    open fun getMessageList(filter: MessageListDatabaseFilter): YSArray<MessageView> {
        return this.getMessageListFromIds(this.getMessageIdList(filter), filter.getIsInThreadMode())
    }

    open fun isMessageInFilter(mid: MessageId, filter: MessageListDatabaseFilter): Boolean {
        if (filter.getContainer() != null) {
            if (!this.isMessageInContainer(mid, filter.getContainer()!!)) {
                return false
            }
        }
        if (filter.getFolder() != null) {
            if (!this.isMessageInFolder(mid, filter.getFolder()!!)) {
                return false
            }
        }
        if (filter.getLabel() != null) {
            if (!this.isMessageInLabel(mid, filter.getLabel()!!)) {
                return false
            }
        }
        if (filter.getIsImportantOnly()) {
            if (!this.isMessageImportant(mid)) {
                return false
            }
        }
        if (filter.getIsUnreadOnly()) {
            if (!this.isMessageUnread(mid)) {
                return false
            }
        }
        for (folderName in filter.getExcludedFolders()) {
            if (this.isMessageInFolder(mid, folderName)) {
                return false
            }
        }
        return true
    }

    open fun getMessagesInThreadByMid(mid: MessageId): YSArray<MessageId> {
        val orderInThreads = this.findThread(mid)
        if (orderInThreads == null) {
            return mutableListOf(mid)
        }
        val threadMids = this.threads[orderInThreads]
        val sortedMids = setToArray(threadMids)
        sortedMids.sort(__LBL__MessageListDatabase_5@ {
            m1, m2 ->
            return@__LBL__MessageListDatabase_5 int64ToInt32(this.storedMessage(m2).mutableHead.timestamp - this.storedMessage(m1).mutableHead.timestamp)
        })
        return sortedMids
    }

    open fun makeMessageThreadView(threadMid: MessageId): FullMessage {
        val threadView = this.storedMessage(threadMid).copy()
        threadView.mutableHead.read = this.getMessagesInThreadByMid(threadMid).filter( {
            mid ->
            !this.storedMessage(mid).head.read
        }).size == 0
        return threadView
    }

    open fun createFolder(folderName: FolderName): Unit {
        if (this.folderToMessages.has(folderName)) {
            fail("Такая папка уже существует!")
        }
        this.folderToMessages.set(folderName, YSSet<MessageId>())
    }

    open fun removeFolder(folderName: FolderName): Unit {
        if (!this.folderToMessages.has(folderName)) {
            fail("Невозможно удалить папку. Такой папки нет!")
        }
        this.folderToMessages.delete(folderName)
    }

    open fun renameFolder(folderName: FolderName, newFolderName: FolderName): Unit {
        if (this.folderToMessages.has(newFolderName) || !this.folderToMessages.has(folderName)) {
            fail("Невозможно переименовать. Папки нет, либо папка с таким именем уже существует!")
        }
        this.folderToMessages.set(newFolderName, this.folderToMessages.`get`(folderName)!!)
        this.folderToMessages.delete(folderName)
    }

    private fun updateTabsToMessages(mid: MessageId, folderName: FolderName): Unit {
        this.tabsToMessages.__forEach( {
            msgIds, _folder ->
            msgIds.delete(mid)
        })
        if (folderName == DefaultFolderName.mailingLists || folderName == DefaultFolderName.socialNetworks || folderName == DefaultFolderName.inbox) {
            this.tabsToMessages.get(folderName)?.add(mid)
        }
    }

    open fun moveMessageToFolder(mid: MessageId, folderName: FolderName, needUpdateTabsToMessages: Boolean = true): Unit {
        this.folderToMessages.__forEach( {
            msgIds, _folder ->
            msgIds.delete(mid)
        })
        this.demandFolderMessages(folderName).add(mid)
        if (needUpdateTabsToMessages) {
            this.updateTabsToMessages(mid, folderName)
        }
    }

    open fun createLabel(labelName: LabelName): Unit {
        if (this.labelToMessages.has(labelName)) {
            fail("Такая метка уже существует!")
        }
        this.labelToMessages.set(labelName, YSSet<MessageId>())
    }

    open fun removeLabel(labelName: LabelName): Unit {
        if (!this.labelToMessages.has(labelName)) {
            fail("Такой метки нет!")
        }
        this.labelToMessages.delete(labelName)
    }

    open fun renameLabel(labelName: LabelName, newLabelName: LabelName): Unit {
        if (this.labelToMessages.has(newLabelName) || !this.labelToMessages.has(labelName)) {
            fail("Невозможно переименовать. Метки нет, либо метка с таким именем уже существует!")
        }
        this.labelToMessages.set(newLabelName, this.labelToMessages.`get`(labelName)!!)
        this.labelToMessages.delete(labelName)
    }

    open fun applyLabelToMessages(labelName: LabelName, mids: YSSet<MessageId>): Unit {
        mids.forEach( {
            mid ->
            this.labelToMessages.get(labelName)?.add(mid)
        })
    }

    open fun removeLabelFromMessages(labelName: LabelName, mids: YSSet<MessageId>): Unit {
        mids.forEach( {
            mid ->
            this.labelToMessages.get(labelName)?.delete(mid)
        })
    }

    open fun getMessageLabels(mid: MessageId): YSSet<String> {
        val messageLabels = YSSet<LabelName>()
        this.labelToMessages.__forEach(__LBL__MessageListDatabase_6@ {
            mids, labelName ->
            if (mids.has(mid)) {
                messageLabels.add(labelName)
            }
        })
        return messageLabels
    }

    open fun addMessage(mid: MessageId, msg: FullMessage, folderName: FolderName): Unit {
        if (!this.folderToMessages.has(folderName)) {
            fail("Папки ${folderName} нет!")
        }
        this.messages.set(mid, msg)
        this.folderToMessages.get(folderName)?.add(mid)
    }

    open fun addThreadMessagesToThreadWithMid(midsToAdd: YSArray<MessageId>, midInThread: MessageId): Unit {
        var threadAdded = false
        this.threads.forEach(__LBL__MessageListDatabase_7@ {
            thread ->
            if (thread.has(midInThread)) {
                midsToAdd.forEach( {
                    midToAdd ->
                    thread.add(midToAdd)
                })
                threadAdded = true
            }
        })
        if (!threadAdded) {
            midsToAdd.add(midInThread)
            this.addThread(midsToAdd)
        }
    }

    open fun addThread(mids: YSArray<MessageId>): Unit {
        this.threads.add(arrayToSet(mids))
    }

    open fun storedMessage(mid: MessageId): FullMessage {
        val message = undefinedToNull(this.messages.get(mid))
        if (message == null) {
            fail("No message with mid ${mid} in model!")
        }
        return message!!
    }

    open fun storedFolder(mid: MessageId): FolderName {
        var folderName: FolderName? = null
        this.folderToMessages.__forEach(__LBL__MessageListDatabase_8@ {
            msgIds, folder ->
            for (msgId in msgIds.values()) {
                if (msgId == mid) {
                    folderName = folder
                }
            }
        })
        if (folderName == null) {
            fail("No folder for message with mid ${mid} in model!")
        }
        return folderName!!
    }

    open fun removeMessage(id: MessageId): Unit {
        if (!this.messages.has(id)) {
            fail("No messages with target id")
        }
        val isInTrash = this.demandFolderMessages(DefaultFolderName.trash).has(id)
        if (isInTrash) {
            this.folderToMessages.__forEach( {
                msgIds, _folderName ->
                msgIds.delete(id)
            })
            this.messages.delete(id)
            for (index in (0 until this.threads.size step 1)) {
                this.threads[index].delete(id)
            }
            this.threads = this.threads.filter( {
                thread ->
                thread.size != 0
            })
        } else {
            this.moveMessageToFolder(id, DefaultFolderName.trash)
        }
    }

    private fun isMessageInContainer(mid: MessageId, container: MessageContainer): Boolean {
        var isInContainer = false
        if (container.type == MessageContainerType.folder) {
            return this.isMessageInFolder(mid, container.name)
        }
        if (container.type == MessageContainerType.label) {
            isInContainer = this.isMessageInLabel(mid, container.name)
        }
        if (container.type == MessageContainerType.importantFilter) {
            isInContainer = this.isMessageImportant(mid)
        }
        if (container.type == MessageContainerType.unreadFilter) {
            isInContainer = this.isMessageUnread(mid)
        }
        if (container.type == MessageContainerType.search) {
            isInContainer = this.isMessageInSearchRequest(mid, container.name)
        }
        if (container.type == MessageContainerType.withAttachmentsFilter) {
            isInContainer = this.isMessageWithAttachment(mid)
        }
        return (isInContainer && !this.isMessageInFolder(mid, DefaultFolderName.trash) && !this.isMessageInFolder(mid, DefaultFolderName.spam))
    }

    private fun isMessageInFolder(mid: MessageId, folderName: FolderName): Boolean {
        return requireNonNull(this.folderToMessages.`get`(folderName)?.has(mid), "Нет такой папки")!!
    }

    private fun isMessageInLabel(mid: MessageId, labelName: LabelName): Boolean {
        return requireNonNull(this.labelToMessages.`get`(labelName)?.has(mid), "Нет такой метки")!!
    }

    private fun isMessageInSearchRequest(mid: MessageId, request: String): Boolean {
        val msg = undefinedToNull(this.messages.get(mid))
        return (msg!!.body.search(request) != -1 || this.isOneOfItemRelevantToRequest(msg!!.to, request) || msg!!.head.subject.search(request) != -1 || msg!!.head.from.search(request) != -1)
    }

    private fun isMessageImportant(mid: MessageId): Boolean {
        return this.messages.`get`(mid)!!.head.important
    }

    private fun isMessageUnread(mid: MessageId): Boolean {
        return !this.messages.`get`(mid)!!.head.read
    }

    private fun isMessageWithAttachment(mid: MessageId): Boolean {
        return this.messages.`get`(mid)!!.head.attachments.size > 0
    }

    private fun buildMessageIdList(msgs: YSArray<MessageId>, limit: Int, isInThreadMode: Boolean): YSArray<MessageId> {
        val sortedMsgs = this.sortMessagesByTimestamp(msgs)
        if (!isInThreadMode) {
            return sortedMsgs.slice(0, limit)
        }
        val threadedMessages: YSArray<MessageId> = mutableListOf()
        val currentAddedThreads = YSSet<Int>()
        for (mid in sortedMsgs) {
            val threadOrder = this.findThread(mid)
            if (threadOrder == null) {
                threadedMessages.add(mid)
            } else if (!currentAddedThreads.has(threadOrder)) {
                threadedMessages.add(mid)
                currentAddedThreads.add(threadOrder)
            }
        }
        return threadedMessages.slice(0, limit)
    }

    private fun demandFolderMessages(folderName: FolderName): YSSet<MessageId> {
        val messages = undefinedToNull(this.folderToMessages.get(folderName))
        if (messages == null) {
            fail("Модель не знает про папку '${folderName}'! Сначала ее надо создать.")
        }
        return messages!!
    }

    private fun isOneOfItemRelevantToRequest(items: YSSet<String>, request: String): Boolean {
        var isRelevant = false
        val requestToFind = requireNonNull(request, "Необходимо задать запрос для поиска!")
        items.forEach(__LBL__MessageListDatabase_9@ {
            item ->
            if (item.search(requestToFind) != -1) {
                isRelevant = true
            }
        })
        return isRelevant
    }

    private fun sortMessagesByTimestamp(unorderedMsgs: YSArray<MessageId>): YSArray<MessageId> {
        unorderedMsgs.sort(__LBL__MessageListDatabase_10@ {
            mid1, mid2 ->
            val diff = int64ToInt32(this.makeMessageThreadView(mid2).mutableHead.timestamp - this.makeMessageThreadView(mid1).mutableHead.timestamp)
            if (diff != 0) {
                return@__LBL__MessageListDatabase_10 diff
            }
            return@__LBL__MessageListDatabase_10 int64ToInt32(mid1 - mid2)
        })
        return unorderedMsgs
    }

    private fun findThread(mid: MessageId): Int? {
        for (i in (0 until this.threads.size step 1)) {
            if (this.threads[i].has(mid)) {
                return i
            }
        }
        return null
    }

    private fun getMessageListFromIds(mids: YSArray<MessageId>, isInThreadMode: Boolean): YSArray<MessageView> {
        return mids.map( {
            mid ->
            if (isInThreadMode) this.makeMessageThreadView(mid).copy().head else this.storedMessage(mid).copy().head
        })
    }

    private fun getMessageHash(message: FullMessage): Long {
        val hashBuilder: HashBuilder = HashBuilder().addString(message.head.from).addBoolean(message.head.read).addString(message.head.subject).addBoolean(message.head.important).addInt64(message.mutableHead.timestamp)
        if (message.head.threadCounter != null) {
            hashBuilder.addInt64(int64(message.head.threadCounter!!))
        } else {
            hashBuilder.addBoolean(true)
        }
        return hashBuilder.build()
    }

}

public open class MessageListDatabaseFilter() {
    private var folder: FolderName?
    private var label: LabelName?
    private var excludedFolders: YSArray<FolderName>
    private var container: MessageContainer?
    private var isInThreadMode: Boolean
    private var isImportantOnly: Boolean
    private var isUnreadOnly: Boolean
    private var limit: Int
    init {
        this.folder = null
        this.label = null
        this.container = null
        this.excludedFolders = mutableListOf()
        this.isInThreadMode = true
        this.limit = 20
        this.isImportantOnly = false
        this.isUnreadOnly = false
    }
    open fun getIsInThreadMode(): Boolean {
        return this.isInThreadMode
    }

    open fun withIsInThreadMode(value: Boolean): MessageListDatabaseFilter {
        this.isInThreadMode = value
        return this
    }

    open fun getIsUnreadOnly(): Boolean {
        return this.isUnreadOnly
    }

    open fun withIsUnreadOnly(): MessageListDatabaseFilter {
        this.isUnreadOnly = true
        return this
    }

    open fun getIsImportantOnly(): Boolean {
        return this.isImportantOnly
    }

    open fun withIsImportantOnly(): MessageListDatabaseFilter {
        this.isImportantOnly = true
        return this
    }

    open fun getContainer(): MessageContainer? {
        return this.container
    }

    open fun withContainer(value: MessageContainer): MessageListDatabaseFilter {
        this.container = value
        return this
    }

    open fun getExcludedFolders(): YSArray<FolderName> {
        return this.excludedFolders
    }

    open fun withExcludedFolders(value: YSArray<FolderName>): MessageListDatabaseFilter {
        this.excludedFolders = value
        return this
    }

    open fun getLabel(): String? {
        return this.label
    }

    open fun withLabel(value: String): MessageListDatabaseFilter {
        this.label = value
        return this
    }

    open fun getFolder(): FolderName? {
        return this.folder
    }

    open fun withFolder(value: FolderName): MessageListDatabaseFilter {
        this.folder = value
        return this
    }

    open fun withLimit(value: Int): MessageListDatabaseFilter {
        this.limit = value
        return this
    }

    open fun getLimit(): Int {
        return this.limit
    }

}

