// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/group-mode-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.*

public open class GroupMarkAsReadDifferentMessagesTest(): RegularYandexMailTestBase("GroupMode. Пометка выбранных писем прочитанными, если одно из них прочитано, а второе - нет") {
    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsReadSelectedMessages())
    }

}

public open class CanOpenMessageAfterGroupActionTest(): RegularYandexMailTestBase("GroupMode. Открытие письма на просмотр после выхода из режима групповых операций") {
    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(MarkAsRead(1)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsUnreadSelectedMessages()).then(OpenMessageAction(0))
    }

}

public open class GroupDeleteMessagesTest(): RegularYandexMailTestBase("GroupMode. Удаление выбранных писем из папки Черновики") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6220).androidCase(6475)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.draft).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.draft)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(DeleteSelectedMessages())
    }

}

public open class GroupModeMarkImportantTest(): RegularYandexMailTestBase("GroupMode. Пометка выбранных писем Важными") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(27).androidCase(6491)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.archive).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive)).then(InitialSelectMessage(1)).then(MarkImportantSelectedAction())
    }

}

public open class GroupModeUnmarkImportantTest(): RegularYandexMailTestBase("GroupMode. Снятие метки Важное") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6238).androidCase(6492)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(MarkImportantSelectedAction()).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(MarkUnimportantSelectedAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class GroupModeMarkLabelTest(): RegularYandexMailTestBase("GroupMode. Добавление пользовательской метки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6245).androidCase(6499)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createLabel("label1").createLabel("label2").nextMessage("subj1").nextThread("thread2", 3).nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(ApplyLabelsToSelectedMessagesAction(mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class GroupModeUnmarkLabelTest(): RegularYandexMailTestBase("GroupMode. Снятие пользовательской метки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6248).androidCase(6502)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label2")).withSubject("subj2")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj3"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(RemoveLabelsFromSelectedMessagesAction(mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class GroupModeMarkReadMessageTest(): RegularYandexMailTestBase("GroupMode. Пометка писем прочитанным в метке Важные") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6513).androidCase(6512)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkImportantSelectedAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsReadSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class GroupModeMarkUnreadMessageTest(): RegularYandexMailTestBase("GroupMode. Пометка писем непрочитанным в пользовательской метке") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6514).androidCase(6515)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label2")).withSubject("subj2")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj3"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsReadSelectedMessages()).then(InitialSelectMessage(1)).then(SelectMessage(0)).then(MarkAsUnreadSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class GroupModeMarkSpamTest(): RegularYandexMailTestBase("GroupMode. Перемещение выбранных писем в Спам") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6233).androidCase(6070)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(2)).then(MarkSpamSelectedAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam))
    }

}

public open class GroupModeArchiveThreadTest(): RegularYandexMailTestBase("GroupMode. Перемещение выбранных тредов в Архив") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6230).androidCase(6484)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 2)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(2)).then(SelectMessage(1)).then(ArchiveSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class GroupModeArchiveMessagesTest(): RegularYandexMailTestBase("GroupMode. Перемещение выбранных писем в Архив из пользовательской метки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6229).androidCase(6483)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label2")).withSubject("subj2")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj3"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(InitialSelectMessage(1)).then(SelectMessage(0)).then(ArchiveSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class GroupModeCancelSelectionTest(): RegularYandexMailTestBase("GroupMode. Выход из режима групповых операций тапом на Отмена") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6508).androidCase(6509)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(2)).then(SelectMessage(1)).then(UnselectAllMessagesAction())
    }

}

public open class GroupModeSelectAllTest(): RegularYandexMailTestBase("GroupMode. Выделить все письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6510).androidCase(6511)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectAllMessages())
    }

}

public open class GroupModeMarkReadThreadTest(): RegularYandexMailTestBase("GroupMode. Пометка выбранных писем прочитанными") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6215).androidCase(6470)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(MarkAsReadSelectedMessages())
    }

}

public open class GroupMarkAsReadMessagesTest(): RegularYandexMailTestBase("GroupMode. Пометка выбранных писем непрочитанными") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6216).androidCase(6471)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("folder").switchFolder("folder").nextMessage("subj1").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("folder")).then(MarkAsRead(0)).then(MarkAsRead(1)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsUnreadSelectedMessages())
    }

}

public open class GroupModeMarkUnreadThreadTest(): RegularYandexMailTestBase("GroupMode. Пометка всех писем выделенного треда непрочитанными") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6516).androidCase(6517)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 5).nextThread("thread2", 7).nextThread("thread3", 2)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(MarkAsRead(0)).then(InitialSelectMessage(0)).then(MarkAsUnreadSelectedMessages())
    }

}

public open class GroupModeDeleteThreadTest(): RegularYandexMailTestBase("GroupMode. Удаление треда все письма которого лежат в папке Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6518).androidCase(6519)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 7).nextThread("thread3", 1)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(DeleteSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class GroupModeMarkSpamThreadTest(): RegularYandexMailTestBase("GroupMode. Перемещение в Спам треда, письма которого лежат в разных папках") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6234).androidCase(6488)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 7).nextThread("thread3", 1).createFolder("AutotestFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(1)).then(MoveMessageToFolderFromMessageViewAction("AutotestFolder")).then(BackToMaillistFromMessageViewAction()).then(InitialSelectMessage(1)).then(MarkSpamSelectedAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam))
    }

}

public open class GroupModeUnmarkSpamTest(): RegularYandexMailTestBase("GroupMode. Пометить письмо как не спам") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6520).androidCase(6535)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.spam).nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkNotSpamSelectedAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class GroupModeMoveThreadsToInboxTest(): RegularYandexMailTestBase("GroupMode. Перемещение выбранных тредов из пользовательской папки во Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6505).androidCase(6506)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("AutoTestFolder").switchFolder("AutoTestFolder").nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("AutoTestFolder")).then(InitialSelectMessage(1)).then(MoveToFolderSelectedMessagesAction(DefaultFolderName.inbox)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class GroupModeMoveMessageToUserFolderFromInboxTest(): RegularYandexMailTestBase("GroupMode. Перемещение писем в другую папку") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6243).androidCase(6497)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3").createFolder("AutotestFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(0)).then(MoveToFolderSelectedMessagesAction("AutotestFolder")).then(OpenFolderListAction()).then(GoToFolderAction("AutotestFolder"))
    }

}

public open class GroupModeInitialSelectTest(): RegularYandexMailTestBase("GroupMode. Переход в режим групповых операций") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(3).androidCase(6068)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectMessage(2))
    }

}

public open class GroupModeExitByTapOnSelectedMessagesTest(): RegularYandexMailTestBase("GroupMode. Выход из режима групповых операций тапом на выделенные письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(4).androidCase(6069)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subject1").nextMessage("subject2").nextMessage("subject3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(SelectMessage(0)).then(UnselectMessageAction(2)).then(UnselectMessageAction(0)).then(UnselectMessageAction(1))
    }

}

public open class GroupModeDeleteFromTrashTest(): RegularYandexMailTestBase("GroupMode. Удаление письма из папки Удаленные") {
    open override fun setupSettings(settings: TestSettings): Unit {
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder("Trash").nextMessage("subject1").nextMessage("subject2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("Trash")).then(InitialSelectMessage(1)).then(DeleteSelectedMessages())
    }

}

public open class GroupModeInitialSelectInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Переход в режим групповых операций и выход из него в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(643).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4").nextMessage("subj5")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(InitialSelectMessage(1)).then(UnselectAllMessagesAction())
    }

}

public open class GroupModeDeleteMessageInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Удаление письма в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(642).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserSubfolder", mutableListOf("UserFolder")).switchFolder("UserSubfolder", mutableListOf("UserFolder")).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserSubfolder", mutableListOf("UserFolder"))).then(InitialSelectMessage(1)).then(DeleteSelectedMessages()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class GroupModeMarkAsSpamNotSpamMessageInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Пометка письма спамом - не спамом в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(644).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.trash)).then(InitialSelectMessage(1)).then(MarkSpamSelectedAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(InitialSelectMessage(0)).then(MarkNotSpamSelectedAction())
    }

}

public open class GroupModeArchiveMessageFromSearchInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Архивирование письма в поиске в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(645).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(InitialSelectMessage(1)).then(ArchiveSelectedMessages()).then(CloseSearchAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class GroupModeSelectAllMessagesInSearchTest(): RegularYandexMailTestBase("Group mode. Выбор всех писем в Поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8982)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").switchFolder("UserFolder").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(InitialSelectMessage(0)).then(SelectAllMessages())
    }

}

public open class GroupModeMarkImportantUnimportantMessageInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Пометка письма важным-неважным в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(646).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("inbox_subj1").nextMessage("inbox_subj2").nextMessage("inbox_subj3").switchFolder(DefaultFolderName.sent).nextMessage("sent_subj1").nextMessage("sent_subj2").nextMessage("sent_subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(InitialSelectMessage(0)).then(MarkImportantSelectedAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.sent)).then(InitialSelectMessage(0)).then(MarkImportantSelectedAction()).then(InitialSelectMessage(0)).then(MarkUnimportantSelectedAction())
    }

}

public open class GroupModeAddRemoveLabelInCompactModeTest(): RegularYandexMailTestBase("GroupMode. Добавление-снятие пользовательской метки в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(648).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createLabel("label1").nextMessage("inbox_subj1").nextMessage("inbox_subj2").nextMessage("inbox_subj3").switchFolder("UserFolder").nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("user_subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("user_subj2")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1", "label2")).withSubject("user_subj3"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(InitialSelectMessage(0)).then(MarkImportantSelectedAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction()).then(InitialSelectMessage(0)).then(ApplyLabelsToSelectedMessagesAction(mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(InitialSelectMessage(0)).then(RemoveLabelsFromSelectedMessagesAction(mutableListOf("label2"))).then(OpenFolderListAction()).then(GoToLabelAction("label2"))
    }

}

public open class GroupModeUndoDeleteThreadTest(): RegularYandexMailTestBase("GroupMode. Отмена удаления треда в папке Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8608)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3).nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(0)).then(DeleteSelectedMessages()).then(UndoDeleteAction())
    }

}

public open class GroupModeUndoArchiveThreadTest(): RegularYandexMailTestBase("GroupMode. Отмена архивирования треда в папке Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8612)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj2").nextThread("thread1", 3).nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(ArchiveSelectedMessages()).then(UndoArchiveAction())
    }

}

public open class GroupModeUndoSpamThreadTest(): RegularYandexMailTestBase("GroupMode. Отмена пометки треда спамом в папке Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8618)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3).nextThread("subj2", 4).nextThread("subj3", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(MarkSpamSelectedAction()).then(UndoSpamAction())
    }

}

public open class GroupModeUndoArchiveMessageTest(): RegularYandexMailTestBase("GroupMode. Отмена архивирования письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8613)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(InitialSelectMessage(1)).then(ArchiveSelectedMessages()).then(UndoArchiveAction())
    }

}

public open class GroupModeUndoArchiveMessagesAndThreadsTest(): RegularYandexMailTestBase("GroupMode. Отмена архивирования нескольких писем и тредов") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8614)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj2").nextThread("thread1", 3).nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(SelectMessage(0)).then(SelectMessage(2)).then(ArchiveSelectedMessages()).then(UndoArchiveAction())
    }

}

public open class GroupModeUndoSpamMessageTest(): RegularYandexMailTestBase("GroupMode. Отмена пометки письма спамом") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8616)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(InitialSelectMessage(1)).then(MarkSpamSelectedAction()).then(UndoSpamAction())
    }

}

public open class GroupModeUndoDeleteMessageTest(): RegularYandexMailTestBase("GroupMode. Отмена удаления письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8617)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createLabel("label1").nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("label1")).withSubject("subj1")).nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToLabelAction("label1")).then(InitialSelectMessage(0)).then(DeleteSelectedMessages()).then(UndoDeleteAction())
    }

}

public open class GroupModeUndoSpamMessagesAndThreadsTest(): RegularYandexMailTestBase("GroupMode. Отмена пометки спамом нескольких писем и тредов") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8602)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj2").nextThread("thread1", 3).nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(SelectMessage(2)).then(MarkSpamSelectedAction()).then(UndoSpamAction())
    }

}

public open class GroupModeUndoDeleteMessagesAndThreadsTest(): RegularYandexMailTestBase("GroupMode. Отмена удаления нескольких писем и тредов") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8607)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextThread("thread1", 3).nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(SelectMessage(2)).then(DeleteSelectedMessages()).then(UndoDeleteAction())
    }

}

public open class GroupModeMoveMessageFromTabInboxToUserFolderTest(): RegularYandexMailTestBase("GroupMode. Перемещение одиночного сообщения из таба в папку") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7584)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.inbox).nextMessage("msg1").nextMessage("msg2").nextMessage("msg3").createFolder("UserFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(InitialSelectMessage(1)).then(MoveToFolderSelectedMessagesAction("UserFolder")).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder"))
    }

}

public open class GroupModeMoveMessageToSpamFromSocialTabTest(): RegularYandexMailTestBase("GroupMode. Отправка письма в Спам из таба") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7592)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.socialNetworks).nextMessage("msg1").nextMessage("msg2").nextMessage("msg3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.socialNetworks)).then(InitialSelectMessage(0)).then(MarkSpamSelectedAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam))
    }

}

public open class GroupModeApplyLabelToMessageInMailingListTabTest(): RegularYandexMailTestBase("GroupMode. Пометка письма пользовательской меткой в табе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7595)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().createLabel("label1").createLabel("label2").switchFolder(TabBackendName.mailingLists).nextMessage("msg1").nextMessage("msg2").nextMessage("msg3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.mailingLists)).then(InitialSelectMessage(0)).then(ApplyLabelsToSelectedMessagesAction(mutableListOf("label1"))).then(OpenFolderListAction()).then(GoToLabelAction("label1"))
    }

}

public open class GroupModeDeleteMessage2paneTest(): RegularYandexMailTestBase("GroupMode. Удаление писем в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8995)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenMessageAction(0)).then(InitialSelectMessage(1)).then(SelectMessage(2)).then(DeleteSelectedMessages()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class GroupModeMardMessagesAsRead2paneTest(): RegularYandexMailTestBase("GroupMode. Пометка писем прочитанными в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8997)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder("UserFolder").nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(MarkAsReadFromShortSwipeAction(1)).then(OpenMessageAction(0)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(SelectMessage(2)).then(MarkAsReadSelectedMessages())
    }

}

