// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/long-swipe-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.*

public open class LongSwipeToDeleteMessageTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма из папки Отправленные") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(24).androidCase(6194)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.sent).nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.sent)).then(DeleteMessageByLongSwipeAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeToDeleteThreadTest(): RegularYandexMailTestBase("LongSwipe. Удаление треда из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6219).androidCase(6474)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByLongSwipeAction(2)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeToArchiveMessageTest(): RegularYandexMailTestBase("LongSwipe. Архивация письма из пользовательской папки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6225).androidCase(6479)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextMessage("subj").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction("UserFolder")).then(ArchiveMessageByLongSwipeAction(0)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class LongSwipeToArchiveThreadTest(): RegularYandexMailTestBase("LongSwipe. Архивация треда из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6226).androidCase(6480)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 2).nextThread("thread2", 3).nextThread("thread3", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(ArchiveMessageByLongSwipeAction(2)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class LongSwipeToArchiveFromArchiveThreadTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма из папки Архив при действии по свайпу Архивировать") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6613).androidCase(6623)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.archive).nextMessage("subj").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.archive)).then(DeleteMessageByLongSwipeAction(1))
    }

}

public open class LongSwipeToDeleteFromTrashTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма длинным свайпом из папки Удаленные") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6612).androidCase(6624)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.trash).nextMessage("subj").nextMessage("subj2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash)).then(DeleteMessageByLongSwipeAction(1))
    }

}

public open class LongSwipeToArchiveInCompactModeTest(): RegularYandexMailTestBase("LongSwipe. Архивация письма длинным свайпом в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(628).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.spam).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.spam)).then(ArchiveMessageByLongSwipeAction(1)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class LongSwipeLongSwipeToDeleteFromSearchInCompactModeTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма длинным свайпом из поиска в компактном режиме") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(626).ignoreOn(MBTPlatform.Android)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(TurnOnCompactMode()).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(DeleteMessageByLongSwipeAction(1))
    }

}

public open class LongSwipeUndoDeleteMessageTest(): RegularYandexMailTestBase("LongSwipe. Отмена удаления письма из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6195).androidCase(6066)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(DeleteMessageByLongSwipeAction(1)).then(UndoDeleteAction())
    }

}

public open class LongSwipeUndoDeleteThreadTest(): RegularYandexMailTestBase("LongSwipe. Отмена удаления треда из Пользовательской папки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8628)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.createFolder("UserFolder").switchFolder("UserFolder").nextThread("subj1", 3).nextThread("subj2", 4)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction("UserFolder")).then(DeleteMessageByLongSwipeAction(0)).then(UndoDeleteAction())
    }

}

public open class LongSwipeUndoArchiveThreadTest(): RegularYandexMailTestBase("LongSwipe. Отмена архивирования треда из папки Входящие") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8626)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3).nextThread("subj2", 2).nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(ArchiveMessageByLongSwipeAction(1)).then(UndoArchiveAction())
    }

}

public open class LongSwipeUndoArchiveMessageTest(): RegularYandexMailTestBase("LongSwipe. Отмена архивирования письма из папки Спам") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8624)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.spam).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.spam)).then(ArchiveMessageByLongSwipeAction(1)).then(UndoArchiveAction())
    }

}

public open class LongSwipeUndoDeleteMessageAtSearchTest(): RegularYandexMailTestBase("LongSwipe. Отмена удаления письма в поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8856)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(DeleteMessageByLongSwipeAction(1)).then(UndoDeleteAction())
    }

}

public open class LongSwipeDeleteMessageAtSearchTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма в поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8852)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(DeleteMessageByLongSwipeAction(1)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeArchiveMessageAtSearchTest(): RegularYandexMailTestBase("LongSwipe. Архивация письма в поиске") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8853)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenGeneralSettingsAction()).then(SetActionOnSwipe(ActionOnSwipe.archive)).then(CloseGeneralSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(ArchiveMessageByLongSwipeAction(2)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class LongSwipeDeleteMessageAtTabMailingListsTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма из таба Рассылки") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7590)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.turnOnTab().switchFolder(TabBackendName.mailingLists).nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.mailingLists)).then(DeleteMessageByLongSwipeAction(1)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeDeleteThreadLandscapeTest(): RegularYandexMailTestBase("LongSwipe. Удаление треда в лендскейпе") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8864)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(DeleteMessageByLongSwipeAction(0)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeDeleteMessageAtSearch2paneTest(): RegularYandexMailTestBase("LongSwipe. Удаление письма в поиске в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8858)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenSearchAction()).then(SearchAllMessagesAction()).then(OpenMessageAction(1)).then(DeleteMessageByLongSwipeAction(1)).then(AssertAction()).then(CloseSearchAction()).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LongSwipeDeleteThread2paneTest(): RegularYandexMailTestBase("LongSwipe. Удаление треда в 2pane") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(8861)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("subj1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(RotateToLandscape()).then(OpenMessageAction(1)).then(DeleteMessageByLongSwipeAction(1)).then(AssertAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

