// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/mail-view-tests.ts >>>

package com.yandex.xplat.testopithecus

import com.yandex.xplat.testopithecus.common.Fuzzer
import com.yandex.xplat.testopithecus.common.TestPlan
import com.yandex.xplat.testopithecus.common.TestSettings
import com.yandex.xplat.testopithecus.common.UserAccount

public open class MarkAsUnreadFromMessageViewTest(): RegularYandexMailTestBase("MailView. Пометка письма непрочитанным из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6283).androidCase(7381)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MarkAsUnreadFromMessageViewAction()).then(BackToMaillistFromMessageViewAction())
    }

}

public open class MarkAsReadFromMessageViewTest(): RegularYandexMailTestBase("MailView. Пометка письма прочитанным из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6282).androidCase(7380)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MarkAsUnreadFromMessageViewAction()).then(MarkAsReadFromMessageViewAction()).then(BackToMaillistFromMessageViewAction())
    }

}

public open class DeleteSingleMessageFromMessageViewTest(): RegularYandexMailTestBase("MailView. Удаление открытого на просмотр единичного письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6285).androidCase(7383)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(DeleteCurrentMessage())
    }

}

public open class DeleteSingleMessageFromThreadFromMessageViewTest(): RegularYandexMailTestBase("MailView. Удаление одного письма из треда из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6284).androidCase(7382)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).thenChain(mutableListOf(DeleteCurrentMessage(), BackToMaillistFromMessageViewAction())).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class MarkAsSpamFromMessageView(): RegularYandexMailTestBase("MailView. Пометка спамом из просмотра одного письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6292).androidCase(7390)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MarkAsSpamFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam))
    }

}

public open class MarkAsNotSpamFromMessageView(): RegularYandexMailTestBase("MailView. Пометка не спамом из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7621).androidCase(7622)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.switchFolder(DefaultFolderName.spam)
        mailbox.nextMessage("subj")
        mailbox.switchFolder(DefaultFolderName.inbox)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.spam)).then(OpenMessageAction(0)).then(UnmarkAsSpamFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ArchiveSingleMessageFromMessageView(): RegularYandexMailTestBase("MailView. Архивация единичного письма из просмотра через меню действий") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6289).androidCase(7387)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(ArchiveFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive)).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.inbox))
    }

}

public open class ArchiveMessageFromThreadFromMessageView(): RegularYandexMailTestBase("MailView. Архивация письма из треда со страницы просмотра письма") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6288).androidCase(7386)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(ArchiveFromMessageViewAction()).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.archive))
    }

}

public open class MoveMessageToUsersFolderFromMessageView(): RegularYandexMailTestBase("MailView. Перемещение единичного письма в пользовательскую папку из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6296).androidCase(7394)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj").createFolder("TestFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MoveMessageToFolderFromMessageViewAction("TestFolder")).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction("TestFolder"))
    }

}

public open class MoveMessageToUsersFolderFromThreadFromMessageView(): RegularYandexMailTestBase("MailView. Перемещение письма из треда в пользовательскую папку из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7623).androidCase(7624)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3).createFolder("TestFolder")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MoveMessageToFolderFromMessageViewAction("TestFolder")).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFolderAction("TestFolder"))
    }

}

public open class MarkImportantFromMessageView(): RegularYandexMailTestBase("MailView. Пометка важным единичного письма из просмотра") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6298).androidCase(7396)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MarkAsImportantFromMessageViewAction()).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class MarkUnimportantFromMessageView(): RegularYandexMailTestBase("MailView. Снятие метки важное из просмотра через меню действий") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7626).androidCase(7625)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(MarkAsImportantFromMessageViewAction()).then(BackToMaillistFromMessageViewAction()).then(OpenMessageAction(0)).then(MarkAsUnimportantFromMessageViewAction()).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToFilterImportantAction())
    }

}

public open class AddLabelsFromMessageView(): RegularYandexMailTestBase("MailView. Добавление нескольких пользовательских меток в просмотре") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(7627).androidCase(7628)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj").createLabel("test1").createLabel("test2")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(AddLabelsFromMessageViewAction(mutableListOf("test1", "test2"))).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToLabelAction("test1")).then(OpenFolderListAction()).then(GoToLabelAction("test2"))
    }

}

public open class DeleteLabelsFromMessageView(): RegularYandexMailTestBase("MailView. Снятие нескольких пользовательских меток в просмотре") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6299).androidCase(7397)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("test1", "test2", "test3")).withSubject("subj"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(DeleteLabelsFromMessageViewAction(mutableListOf("test1", "test2"))).then(BackToMaillistFromMessageViewAction()).then(OpenFolderListAction()).then(GoToLabelAction("test1")).then(OpenFolderListAction()).then(GoToLabelAction("test2"))
    }

}

public open class DeleteMessageFromMessageViewThreadModeOff(): RegularYandexMailTestBase("MailView. Удаление письма из просмотра при выключенной группировке") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.androidCase(4395)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenFolderListAction()).then(OpenSettingsAction()).then(OpenAccountSettingsAction(0)).then(SwitchOffThreadingAction()).then(CloseAccountSettingsAction()).then(CloseRootSettings()).then(GoToFolderAction(DefaultFolderName.inbox)).then(OpenMessageAction(0)).then(DeleteCurrentMessage()).then(OpenFolderListAction()).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

public open class LablesViewFromMessageView(): RegularYandexMailTestBase("MailView. Отображение меток в просмотре") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6896).androidCase(7138)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        val fuzzer = Fuzzer()
        mailbox.nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("test1", "test2", "test3", "test4", "test5", "test6", "test7", "test8", "test9", "test10", "test11", "test12")).withSubject("subj1")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf("1", "12", "12345", "1234567890", "123456789012345")).withSubject("subj2")).nextCustomMessage(MessageSpecBuilder().withDefaults().addLabels(mutableListOf(fuzzer.naughtyString(14), fuzzer.naughtyString(15), fuzzer.naughtyString(11), fuzzer.naughtyString(12), fuzzer.naughtyString(10))).withSubject("subj3"))
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(BackToMaillistFromMessageViewAction()).then(OpenMessageAction(1)).then(BackToMaillistFromMessageViewAction()).then(OpenMessageAction(2))
    }

}

public open class MarkAsReadByOpeningMessageViewTest(): RegularYandexMailTestBase("MailView. Автоматическая пометка письма прочитанным при открытии") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.iosCase(6898).androidCase(7140)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextMessage("subj")
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).then(CheckIfReadFromMessageViewAction())
    }

}

public open class MarkAsReadByExpandThreadTest(): RegularYandexMailTestBase("MailView. Автоматическая пометка письма треда прочитанным при разворачивании") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.androidCase(7125).iosCase(6883)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3).nextThread("thread2", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(ExpandThreadAction(0)).then(OpenMessageAction(1))
    }

}

public open class DeleteMessageByTapOnIconTest(): RegularYandexMailTestBase("MailView. Удалить письмо тапом на иконку") {
    open override fun setupSettings(settings: TestSettings): Unit {
        settings.androidCase(6081)
    }

    open override fun prepareAccount(mailbox: MailboxBuilder): Unit {
        mailbox.nextThread("thread1", 3)
    }

    open override fun regularScenario(account: UserAccount): TestPlan {
        return this.yandexLogin(account).then(OpenMessageAction(0)).thenChain(mutableListOf(DeleteMessageByIcon(), BackToMaillistFromMessageViewAction())).then(GoToFolderAction(DefaultFolderName.trash))
    }

}

